/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.view.popup;

import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import com.atlassian.theplugin.commons.bamboo.BambooPopupInfo;
import com.atlassian.theplugin.commons.bamboo.BuildStatus;
import com.atlassian.theplugin.eclipse.preferences.Activator;
import com.atlassian.theplugin.eclipse.util.PluginIcons;
import com.atlassian.theplugin.eclipse.view.popup.AbstractNotificationPopup;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NotificationPopup
extends AbstractNotificationPopup {
    private static final RGB COLOR_BUILD_FAILED = new RGB(255, 220, 220);
    private static final RGB COLOR_BUILD_SUCCEEDED = new RGB(220, 255, 220);
    private BambooPopupInfo content = new BambooPopupInfo();
    private BuildStatus status = BuildStatus.UNKNOWN;

    public NotificationPopup(Display display) {
        super(display);
    }

    public NotificationPopup(Shell shell) {
        super(shell.getDisplay());
    }

    protected void createTitleArea(Composite parent) {
        ((GridData)parent.getLayoutData()).heightHint = 24;
        Label titleLabel = new Label(parent, 0);
        titleLabel.setText("Bamboo notification");
        titleLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        titleLabel.setBackground(parent.getBackground());
        Label closeButton = new Label(parent, 0);
        closeButton.setText("Close");
        closeButton.setLayoutData((Object)new GridData(128));
        closeButton.setCursor(parent.getDisplay().getSystemCursor(21));
        closeButton.setImage(PluginIcons.getImageRegistry().get("Close"));
        closeButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                NotificationPopup.this.close();
            }
        });
    }

    protected void createContentArea(Composite parent) {
        Color backgroundColor;
        switch (this.status) {
            case BUILD_FAILED: {
                backgroundColor = new Color(Activator.getDefault().getDisplay(), COLOR_BUILD_FAILED);
                break;
            }
            case BUILD_SUCCEED: {
                backgroundColor = new Color(Activator.getDefault().getDisplay(), COLOR_BUILD_SUCCEEDED);
                break;
            }
            default: {
                backgroundColor = parent.getBackground();
            }
        }
        parent.setBackground(backgroundColor);
        for (BambooBuild build : this.content.getBambooBuilds()) {
            String st;
            String icon;
            switch (build.getStatus()) {
                case BUILD_SUCCEED: {
                    icon = PluginIcons.ICON_BAMBOO_SUCCEEDED;
                    st = "succeeded";
                    Color fontColor = Activator.getDefault().getDisplay().getSystemColor(2);
                    break;
                }
                case BUILD_FAILED: {
                    icon = PluginIcons.ICON_BAMBOO_FAILED;
                    st = "failed";
                    Color fontColor = Activator.getDefault().getDisplay().getSystemColor(4);
                    break;
                }
                default: {
                    icon = PluginIcons.ICON_BAMBOO_UNKNOWN;
                    st = "unknown";
                    Color fontColor = Activator.getDefault().getDisplay().getSystemColor(2);
                }
            }
            Composite notificationComposite = new Composite(parent, 524288);
            notificationComposite.setLayout((Layout)new GridLayout(2, false));
            notificationComposite.setBackground(parent.getBackground());
            Label image = new Label(notificationComposite, 524288);
            image.setText("example build");
            image.setImage(PluginIcons.getImageRegistry().get(icon));
            image.setBackground(parent.getBackground());
            Label l2 = new Label(notificationComposite, 524288);
            l2.setText(build.getBuildKey() + " " + build.getBuildNumber() + " " + st);
            l2.setBackground(parent.getBackground());
        }
    }

    protected String getPopupShellTitle() {
        return "Sample Notification";
    }

    public void resetState() {
    }

    public void setContent(BuildStatus status, BambooPopupInfo popupInfo) {
        this.status = status;
        this.content = popupInfo;
    }
}

