/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.view.popup;

import com.atlassian.theplugin.eclipse.view.popup.AbstractTask;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.PlatformObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTaskContainer
extends PlatformObject
implements Comparable<AbstractTaskContainer> {
    private String handleIdentifier = "";
    private Set<AbstractTask> children = new CopyOnWriteArraySet<AbstractTask>();
    protected String url = null;

    public AbstractTaskContainer(String handleAndDescription) {
        assert (this.handleIdentifier != null);
        this.handleIdentifier = handleAndDescription;
    }

    public void internalAddChild(AbstractTask task) {
        this.children.add(task);
    }

    public void internalRemoveChild(AbstractTask task) {
        this.children.remove(task);
    }

    public void clear() {
        this.children.clear();
    }

    public Set<AbstractTask> getChildren() {
        if (this.children.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<AbstractTask> childrenWithoutCycles = new HashSet<AbstractTask>(this.children.size());
        for (AbstractTask child : this.children) {
            if (child.contains(this.getHandleIdentifier())) continue;
            childrenWithoutCycles.add(child);
        }
        return childrenWithoutCycles;
    }

    public Set<AbstractTask> getChildrenInternal() {
        return this.children;
    }

    public boolean contains(String handle) {
        return this.containsHelper(this.getChildrenInternal(), handle, 0);
    }

    private boolean containsHelper(Set<AbstractTask> children, String handle, int depth) {
        if (depth < 10 && children != null && !children.isEmpty()) {
            for (AbstractTask child : children) {
                if (!handle.equals(child.getHandleIdentifier()) && !this.containsHelper(child.getChildrenInternal(), handle, depth + 1)) continue;
                return true;
            }
        }
        return false;
    }

    public String getSummary() {
        return this.handleIdentifier;
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public String getHandleIdentifier() {
        return this.handleIdentifier;
    }

    public void setHandleIdentifier(String handleIdentifier) {
        this.handleIdentifier = handleIdentifier;
    }

    public int hashCode() {
        return this.handleIdentifier.hashCode();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof AbstractTaskContainer) {
            AbstractTaskContainer compare = (AbstractTaskContainer)object;
            return this.getHandleIdentifier().equals(compare.getHandleIdentifier());
        }
        return false;
    }

    public String toString() {
        return "container: " + this.handleIdentifier;
    }

    public String getPriority() {
        String highestPriority = AbstractTask.PriorityLevel.P5.toString();
        Set<AbstractTask> tasks = this.getChildren();
        if (tasks.isEmpty()) {
            return AbstractTask.PriorityLevel.P1.toString();
        }
        for (AbstractTask task : tasks) {
            if (highestPriority.compareTo(task.getPriority()) <= 0) continue;
            highestPriority = task.getPriority();
        }
        return highestPriority;
    }

    @Override
    public int compareTo(AbstractTaskContainer taskListElement) {
        return this.getHandleIdentifier().compareTo(taskListElement.getHandleIdentifier());
    }

    public boolean isUserManaged() {
        return true;
    }
}

