/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.view.bamboo;

import com.atlassian.theplugin.commons.bamboo.BambooPopupInfo;
import com.atlassian.theplugin.commons.bamboo.BambooStatusDisplay;
import com.atlassian.theplugin.commons.bamboo.BuildStatus;
import com.atlassian.theplugin.eclipse.preferences.Activator;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PartInitException;

public class BambooToolWindowHtmlContent
implements BambooStatusDisplay {
    private Browser htmlBrowser;
    private static boolean linkClicked = false;
    private static String html;

    public BambooToolWindowHtmlContent(Composite parent) {
        this.htmlBrowser = new Browser(parent, 0);
        this.htmlBrowser.addMouseListener((MouseListener)new MouseClickListener());
        this.htmlBrowser.addLocationListener((LocationListener)new BrowserLocationListener(this.htmlBrowser));
    }

    public void updateBambooStatus(BuildStatus arg0, BambooPopupInfo info) {
        html = info.toHtml();
        linkClicked = false;
        this.htmlBrowser.setText(html);
    }

    private class BrowserLocationListener
    extends LocationAdapter {
        private Browser browser;

        public BrowserLocationListener(Browser htmlBrowser) {
            this.browser = htmlBrowser;
        }

        public void changing(LocationEvent event) {
            super.changing(event);
            if (linkClicked) {
                try {
                    Activator.getDefault().getWorkbench().getBrowserSupport().createBrowser(128, "aCustomId", "url", "url").openURL(new URL(event.location));
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                this.browser.stop();
                this.browser.setText(html);
                linkClicked = false;
                System.out.println("changing");
            }
        }
    }

    private class MouseClickListener
    extends MouseAdapter {
        public MouseClickListener() {
            System.out.print("");
        }

        public void mouseUp(MouseEvent e) {
            super.mouseUp(e);
            linkClicked = true;
            System.out.println("click");
        }
    }
}

