/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.util;

import com.atlassian.theplugin.eclipse.preferences.Activator;
import com.atlassian.theplugin.eclipse.util.PatternProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtil {
    public static final IResource[] NO_CHILDREN = new IResource[0];
    public static final int COPY_NO_OPTIONS = 0;
    public static final int COPY_IGNORE_EXISTING_FOLDERS = 1;
    public static final int COPY_OVERRIDE_EXISTING_FILES = 2;

    public static IResource selectOneOf(IResource[] scope, IResource[] set) {
        for (int i = 0; i < set.length; ++i) {
            if (!FileUtil.relatesTo(scope, set[i])) continue;
            return set[i];
        }
        return null;
    }

    public static boolean relatesTo(IResource[] set, IResource resource) {
        for (int i = 0; i < set.length; ++i) {
            if (!FileUtil.relatesTo(set[i], resource)) continue;
            return true;
        }
        return false;
    }

    public static boolean relatesTo(IResource set, IResource resource) {
        return set.equals(resource) ? true : (resource == null ? false : FileUtil.relatesTo(set, (IResource)resource.getParent()));
    }

    public static String getResource(ResourceBundle bundle, String key) {
        if (key == null) {
            return null;
        }
        if (bundle == null) {
            return key;
        }
        String retVal = FileUtil.getResourceImpl(bundle, key);
        if (retVal != null) {
            String id;
            if (key.indexOf("Error") != -1 && (id = FileUtil.getResourceImpl(bundle, key + ".Id")) != null) {
                retVal = id + ": " + retVal;
            }
            return retVal;
        }
        return key;
    }

    public static String getWorkingCopyPath(IResource resource) {
        return FileUtil.getResourcePath(resource).toString();
    }

    public static IPath getResourcePath(IResource resource) {
        IPath location = resource.getLocation();
        if (location == null) {
            String errMessage = Activator.getDefault().getResource("Error.InaccessibleResource");
            throw new RuntimeException(MessageFormat.format(errMessage, resource.getFullPath().toString()));
        }
        return location;
    }

    public static Map<String, String> getEnvironmentVariables() {
        try {
            Method getenv = System.class.getMethod("getenv", null);
            return (Map)getenv.invoke((Object)null, (Object[])null);
        }
        catch (Exception ex) {
            try {
                String varLine;
                boolean isWindows = FileUtil.isWindows();
                Process p = isWindows ? Runtime.getRuntime().exec("cmd.exe /c set") : Runtime.getRuntime().exec("env");
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                HashMap<String, String> retVal = new HashMap<String, String>();
                while ((varLine = br.readLine()) != null) {
                    int idx = varLine.indexOf(61);
                    if (idx != -1) {
                        String name = varLine.substring(0, idx);
                        retVal.put(isWindows ? name.toUpperCase() : name, varLine.substring(idx + 1));
                        continue;
                    }
                    if (varLine.length() <= 0) continue;
                    retVal.put(varLine, "");
                }
                return retVal;
            }
            catch (IOException ex1) {
                return Collections.EMPTY_MAP;
            }
        }
    }

    public static String normalizePath(String path) {
        return FileUtil.isWindows() ? path.replace('/', '\\') : path.replace('\\', '/');
    }

    public static boolean isWindows() {
        return FileUtil.getOSName().indexOf("windows") != -1;
    }

    public static String getOSName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static boolean isCaseInsensitiveOS() {
        return "macosx".equals(Platform.getOS()) || new File("a").compareTo(new File("A")) == 0;
    }

    public static boolean isLinked(IResource resource) {
        return resource.isLinked(512);
    }

    public static String[] asPathArray(IResource[] resources) {
        String[] retVal = new String[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            retVal[i] = FileUtil.normalizePath(FileUtil.getWorkingCopyPath(resources[i]));
        }
        return retVal;
    }

    public static String[] asPathArray(File[] files) {
        String[] retVal = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            retVal[i] = FileUtil.normalizePath(files[i].getAbsolutePath());
        }
        return retVal;
    }

    public static String formatResourceName(String projectName) {
        return PatternProvider.replaceAll(projectName, "([\\/:])+", ".");
    }

    public static String formatPath(String path) {
        return PatternProvider.replaceAll(path, "\\\\", "/");
    }

    public static String getUsernameParam(String username) {
        return username == null || username.trim().length() == 0 ? "" : " --username \"" + username + "\"";
    }

    public static String flattenText(String text) {
        StringBuffer flat = new StringBuffer(text.length() + 20);
        boolean skipAdjacentLineSeparator = true;
        for (int i = 0; i < text.length(); ++i) {
            char currentChar = text.charAt(i);
            if (currentChar == '\r' || currentChar == '\n') {
                if (!skipAdjacentLineSeparator) {
                    flat.append("/");
                }
                skipAdjacentLineSeparator = true;
                continue;
            }
            flat.append(currentChar);
            skipAdjacentLineSeparator = false;
        }
        return flat.toString().replace('\t', ' ');
    }

    public static int getMaxStringLength(String[] strings) {
        int result = 0;
        for (int i = 0; i < strings.length; ++i) {
            result = Math.max(result, strings[i].length());
        }
        return result;
    }

    public static String formatMultilineText(String text) {
        if (text.length() > 0 && text.substring(0, 1).matches("(\\s)+")) {
            text = text.replaceFirst("(\\s)+", "");
        }
        if (text.length() == 0) {
            return "";
        }
        text = text.replace('\t', ' ');
        int idx = text.indexOf(10);
        int idx1 = text.indexOf(13);
        if (idx == -1) {
            idx = idx1;
        }
        int n = idx = idx < idx1 || idx1 == -1 ? idx : idx1;
        if (idx != -1) {
            if (text.substring(idx).trim().length() != 0) {
                return text.substring(0, idx) + "...";
            }
            return text.substring(0, idx);
        }
        return text;
    }

    public static String[] decodeStringToArray(String encodedString) {
        String[] valuesArray = new String[]{};
        if (encodedString != null && encodedString.length() > 0) {
            valuesArray = encodedString.split(";");
            for (int i = 0; i < valuesArray.length; ++i) {
                valuesArray[i] = new String(Base64.decode((byte[])valuesArray[i].getBytes()));
            }
        }
        return valuesArray;
    }

    public static String encodeArrayToString(String[] valuesArray) {
        String result = "";
        for (int i = 0; i < valuesArray.length; ++i) {
            String str = new String(Base64.encode((byte[])valuesArray[i].getBytes()));
            result = result + (result.length() == 0 ? str : ";" + str);
        }
        return result;
    }

    public static void visitNodes(IResource resource, IResourceVisitor visitor, int depth) throws CoreException {
        boolean stepInside = visitor.visit(resource);
        if (stepInside && resource instanceof IContainer && depth != 0 && resource.isAccessible()) {
            IContainer container = (IContainer)resource;
            IResource[] children = FileUtil.resourceMembers(container, true);
            int nextDepth = depth == 1 ? 0 : depth;
            for (int i = 0; i < children.length; ++i) {
                FileUtil.visitNodes(children[i], visitor, nextDepth);
            }
        }
    }

    public static boolean deleteRecursive(File node) {
        return FileUtil.deleteRecursive(node, null);
    }

    public static boolean deleteRecursive(File node, IProgressMonitor monitor) {
        File[] files;
        if (node.isDirectory() && (files = node.listFiles()) != null) {
            for (int i = 0; !(i >= files.length || monitor != null && monitor.isCanceled()); ++i) {
                FileUtil.deleteRecursive(files[i], monitor);
            }
        }
        return node.delete();
    }

    public static void copyAll(File to, File what, IProgressMonitor monitor) throws Exception {
        FileUtil.copyAll(to, what, false, monitor);
    }

    public static void copyAll(File to, File what, boolean ignoreExistingFolders, IProgressMonitor monitor) throws Exception {
        FileUtil.copyAll(to, what, ignoreExistingFolders ? 1 : 0, null, monitor);
    }

    public static void copyAll(File to, File what, int options, FileFilter filter, IProgressMonitor monitor) throws Exception {
        if (what.isDirectory()) {
            to = new File(to.getAbsolutePath() + "/" + what.getName());
            if (monitor.isCanceled()) {
                return;
            }
            if (!to.mkdirs() && (options & 1) == 0) {
                String errMessage = Activator.getDefault().getResource("Error.CreateDirectory");
                throw new Exception(MessageFormat.format(errMessage, to.getAbsolutePath()));
            }
            File[] files = what.listFiles(filter);
            if (files != null) {
                for (int i = 0; i < files.length && !monitor.isCanceled(); ++i) {
                    FileUtil.copyAll(to, files[i], options, filter, monitor);
                }
            }
        } else {
            FileUtil.copyFile(to, what, options, monitor);
        }
    }

    public static void copyFile(File to, File what, IProgressMonitor monitor) throws Exception {
        FileUtil.copyFile(to, what, 2, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File to, File what, int options, IProgressMonitor monitor) throws Exception {
        if (to.exists() && to.isDirectory()) {
            to = new File(to.getAbsolutePath() + "/" + what.getName());
        }
        if (!(to.exists() && (options & 2) == 0 || monitor.isCanceled())) {
            FileOutputStream output = null;
            FileInputStream input = null;
            try {
                output = new FileOutputStream(to);
                input = new FileInputStream(what);
                byte[] buf = new byte[2048];
                int loaded = 0;
                while ((loaded = input.read(buf)) > 0 && !monitor.isCanceled()) {
                    output.write(buf, 0, loaded);
                }
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (Exception ex) {}
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
    }

    public static IResource[] getPathNodes(IResource resource) {
        return FileUtil.getPathNodes(new IResource[]{resource});
    }

    public static IResource[] getPathNodes(IResource[] resources) {
        List<IResource> tmp = Arrays.asList(resources);
        HashSet<IResource> modifiedRoots = new HashSet<IResource>();
        IWorkspaceRoot wRoot = ResourcesPlugin.getWorkspace().getRoot();
        for (int i = 0; i < resources.length; ++i) {
            IResource root = resources[i];
            while ((root = root.getParent()) != wRoot && !tmp.contains(root)) {
                modifiedRoots.add(root);
            }
        }
        return modifiedRoots.toArray(new IResource[modifiedRoots.size()]);
    }

    public static void reorder(IResource[] resources, final boolean parent2Child) {
        Arrays.sort(resources, new Comparator<IResource>(){

            @Override
            public int compare(IResource rf, IResource rs) {
                String first = rf.getFullPath().toString();
                String second = rs.getFullPath().toString();
                return parent2Child ? first.compareTo(second) : second.compareTo(first);
            }
        });
    }

    public static void reorder(File[] files, final boolean parent2Child) {
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                String first = o1.getAbsolutePath();
                String second = o2.getAbsolutePath();
                return parent2Child ? first.compareTo(second) : second.compareTo(first);
            }
        });
    }

    public static IResource[] shrinkChildNodes(IResource[] resources) {
        HashSet<IResource> tRoots = new HashSet<IResource>(Arrays.asList(resources));
        for (int i = 0; i < resources.length; ++i) {
            if (!FileUtil.hasRoots(tRoots, resources[i])) continue;
            tRoots.remove(resources[i]);
        }
        return tRoots.toArray(new IResource[tRoots.size()]);
    }

    public static File[] shrinkChildNodes(File[] files, boolean skipFiles) {
        HashSet<File> tRoots = new HashSet<File>(Arrays.asList(files));
        for (int i = 0; i < files.length; ++i) {
            if (skipFiles && files[i].isFile() || !FileUtil.hasRoots(tRoots, files[i])) continue;
            tRoots.remove(files[i]);
        }
        return tRoots.toArray(new File[tRoots.size()]);
    }

    public static IResource[] resourceMembers(IContainer node, boolean includePhantoms) throws CoreException {
        try {
            return node.members(includePhantoms);
        }
        catch (CoreException ex) {
            if (node.isAccessible()) {
                throw ex;
            }
            return new IResource[0];
        }
    }

    public static boolean hasNature(IResource resource, String natureId) throws CoreException {
        IProject project = resource.getProject();
        if (project == null) {
            return false;
        }
        String[] natureIds = project.getDescription().getNatureIds();
        for (int i = 0; i < natureIds.length; ++i) {
            if (!natureId.equals(natureIds[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean hasRoots(Set<IResource> roots, IResource node) {
        while ((node = node.getParent()) != null) {
            if (!roots.contains(node)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasRoots(Set<File> roots, File node) {
        while ((node = node.getParentFile()) != null) {
            if (!roots.contains(node)) continue;
            return true;
        }
        return false;
    }

    private static String getResourceImpl(ResourceBundle bundle, String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    private FileUtil() {
    }
}

