/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.ui.wizard.bamboo;

import com.atlassian.theplugin.eclipse.core.bamboo.IBambooServer;
import com.atlassian.theplugin.eclipse.core.operation.IActionOperation;
import com.atlassian.theplugin.eclipse.preferences.Activator;
import com.atlassian.theplugin.eclipse.ui.utility.UIMonitorUtil;
import com.atlassian.theplugin.eclipse.ui.wizard.AbstractSVNWizard;
import com.atlassian.theplugin.eclipse.ui.wizard.bamboo.AddBambooServerPage;
import com.atlassian.theplugin.eclipse.view.bamboo.BambooConfigurationStorage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewBambooServerWizard
extends AbstractSVNWizard
implements INewWizard {
    protected AddBambooServerPage serverPage;
    protected IBambooServer editable;
    protected boolean performAction;
    protected IBambooServer backup;

    public NewBambooServerWizard() {
        this(null, true);
    }

    public NewBambooServerWizard(IBambooServer editable, boolean performAction) {
        this.performAction = performAction;
        this.editable = editable;
        if (this.editable != null) {
            this.setWindowTitle(Activator.getDefault().getResource("NewBambooServerWizard.Title.Edit"));
            this.backup = BambooConfigurationStorage.instance().newBambooServer();
            BambooConfigurationStorage.instance().copyBambooServer(this.backup, this.editable);
        } else {
            this.setWindowTitle(Activator.getDefault().getResource("NewBambooServerWizard.Title.New"));
        }
    }

    public void addPages() {
        this.serverPage = new AddBambooServerPage(this.editable);
        this.addPage((IWizardPage)this.serverPage);
    }

    public IActionOperation getOperationToPerform() {
        return this.serverPage.getOperationToPeform();
    }

    public boolean performCancel() {
        if (this.editable != null) {
            BambooConfigurationStorage.instance().copyBambooServer(this.editable, this.backup);
        }
        return super.performCancel();
    }

    public boolean performFinish() {
        if (this.serverPage.performFinish()) {
            IActionOperation op;
            if (this.performAction && (op = this.serverPage.getOperationToPeform()) != null) {
                UIMonitorUtil.doTaskBusyDefault(op);
            }
            return true;
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

