/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.ui.wizard.bamboo;

import com.atlassian.theplugin.eclipse.core.bamboo.BambooUtility;
import com.atlassian.theplugin.eclipse.core.bamboo.IBambooServer;
import com.atlassian.theplugin.eclipse.core.operation.AbstractNonLockingOperation;
import com.atlassian.theplugin.eclipse.core.operation.CompositeOperation;
import com.atlassian.theplugin.eclipse.core.operation.IActionOperation;
import com.atlassian.theplugin.eclipse.core.operation.bamboo.AddBambooServerOperation;
import com.atlassian.theplugin.eclipse.core.operation.bamboo.RefreshBambooServersOperation;
import com.atlassian.theplugin.eclipse.core.operation.bamboo.SaveBambooServersOperation;
import com.atlassian.theplugin.eclipse.preferences.Activator;
import com.atlassian.theplugin.eclipse.ui.composite.bamboo.BambooServerPropertiesTabFolder;
import com.atlassian.theplugin.eclipse.ui.dialog.bamboo.NonValidBambooLocationErrorDialog;
import com.atlassian.theplugin.eclipse.ui.panel.AbstractDialogPanel;
import com.atlassian.theplugin.eclipse.ui.utility.UIMonitorUtil;
import com.atlassian.theplugin.eclipse.ui.verifier.AbstractFormattedVerifier;
import com.atlassian.theplugin.eclipse.ui.wizard.AbstractVerifiedWizardPage;
import com.atlassian.theplugin.eclipse.util.PluginIcons;
import com.atlassian.theplugin.eclipse.view.bamboo.BambooConfigurationStorage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class AddBambooServerPage
extends AbstractVerifiedWizardPage {
    protected BambooServerPropertiesTabFolder propertiesTabFolder;
    protected IActionOperation operationToPerform;
    protected IBambooServer editable;
    protected boolean alreadyConnected;
    protected boolean createNew;
    protected String initialUrl;
    protected String oldUrl;
    protected String oldLabel;
    protected String oldUuid;

    public AddBambooServerPage() {
        this((IBambooServer)null);
    }

    public AddBambooServerPage(IBambooServer editable) {
        super(AddBambooServerPage.class.getName(), Activator.getDefault().getResource("AddBambooServerPage.Title"), ImageDescriptor.createFromImage((Image)PluginIcons.getImageRegistry().get("Bamboo_large")));
        this.setDescription(Activator.getDefault().getResource("AddBambooServerPage.Description"));
        this.editable = editable;
        if (editable != null) {
            this.oldUrl = editable.getUrl();
            this.oldLabel = editable.getLabel();
            this.oldUuid = null;
        }
        this.alreadyConnected = false;
        this.createNew = true;
    }

    protected Composite createControlImpl(Composite parent) {
        this.propertiesTabFolder = new BambooServerPropertiesTabFolder(parent, 0, this, this.editable);
        this.propertiesTabFolder.initialize();
        this.propertiesTabFolder.setLayoutData(new GridData(768));
        this.propertiesTabFolder.resetChanges();
        return this.propertiesTabFolder;
    }

    public void setInitialUrl(String initialUrl) {
        this.initialUrl = initialUrl;
        this.alreadyConnected = initialUrl != null;
        if (this.alreadyConnected) {
            this.createNew = initialUrl.trim().length() == 0;
            this.getBambooServer().setUrl(initialUrl);
            this.propertiesTabFolder.resetChanges();
        }
    }

    public void setForceDisableRoots(boolean force) {
        this.propertiesTabFolder.setForceDisableRoots(force, this.initialUrl == null || this.initialUrl.length() == 0 ? null : new AbstractFormattedVerifier(Activator.getDefault().getResource("AddBambooServerPage.RootURL")){

            protected String getErrorMessageImpl(Control input) {
                return null;
            }

            protected String getWarningMessageImpl(Control input) {
                return null;
            }
        });
    }

    public IBambooServer getBambooServer() {
        return this.propertiesTabFolder.getBambooServer();
    }

    public boolean canFlipToNextPage() {
        return (!this.alreadyConnected || this.createNew) && this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        return this.performFinish() ? super.getNextPage() : this;
    }

    public IWizardPage getPreviousPage() {
        this.performCancel();
        return super.getPreviousPage();
    }

    public void performCancel() {
        this.operationToPerform = null;
    }

    public boolean performFinish() {
        this.propertiesTabFolder.saveChanges();
        if (this.propertiesTabFolder.isValidateOnFinishRequested()) {
            NonValidBambooLocationErrorDialog dialog;
            final Exception[] problem = new Exception[1];
            UIMonitorUtil.doTaskNowDefault(this.getShell(), new AbstractNonLockingOperation("Operation.ValidateBambooServer"){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    problem[0] = BambooUtility.validateBambooLocation(AddBambooServerPage.this.propertiesTabFolder.getBambooServer());
                }
            }, false);
            if (problem[0] != null && (dialog = new NonValidBambooLocationErrorDialog(this.getShell(), problem[0].getMessage())).open() != 0) {
                return false;
            }
        }
        boolean shouldntBeAdded = this.editable == null ? false : BambooConfigurationStorage.instance().getBambooServer(this.editable.getId()) != null;
        AbstractNonLockingOperation mainOp = shouldntBeAdded ? new AbstractNonLockingOperation("Operation.CommitLocationChanges"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
            }
        } : new AddBambooServerOperation(this.getBambooServer());
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        op.add(mainOp);
        op.add(new SaveBambooServersOperation());
        op.add(shouldntBeAdded ? new RefreshBambooServersOperation(new IBambooServer[]{this.editable}, true) : new RefreshBambooServersOperation(false));
        this.operationToPerform = op;
        return true;
    }

    public IActionOperation getOperationToPeform() {
        return this.operationToPerform;
    }

    protected static class ProjectListPanel
    extends AbstractDialogPanel {
        protected IProject[] resources;
        protected TableViewer tableViewer;

        public ProjectListPanel(IProject[] input, boolean differentUuid) {
            super(new String[]{IDialogConstants.OK_LABEL});
            this.dialogTitle = Activator.getDefault().getResource("AddBambooServerPage.ProjectList.Title");
            this.dialogDescription = Activator.getDefault().getResource("AddBambooServerPage.ProjectList.Description");
            this.defaultMessage = Activator.getDefault().getResource(differentUuid ? "AddBambooServerPage.ProjectList.Message1" : "AddBambooServerPage.ProjectList.Message2");
            this.resources = input;
        }

        public void createControls(Composite parent) {
        }

        protected void saveChanges() {
        }

        protected void cancelChanges() {
        }
    }
}

