/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.ui.utility;

import com.atlassian.theplugin.eclipse.preferences.Activator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.internal.preferences.Base64;

public class UserInputHistory {
    protected static final String HISTORY_NAME_BASE = "history.";
    protected String name;
    protected int depth;
    protected List<String> history;

    public UserInputHistory(String name) {
        this(name, 5);
    }

    public UserInputHistory(String name, int depth) {
        this.name = name;
        this.depth = depth;
        this.loadHistoryLines();
    }

    public String getName() {
        return this.name;
    }

    public int getDepth() {
        return this.depth;
    }

    public String[] getHistory() {
        return this.history.toArray(new String[this.history.size()]);
    }

    public void addLine(String line) {
        if (line == null || line.trim().length() == 0) {
            return;
        }
        this.history.remove(line);
        this.history.add(0, line);
        if (this.history.size() > this.depth) {
            this.history.remove(this.history.size() - 1);
        }
        this.saveHistoryLines();
    }

    public void clear() {
        this.history.clear();
        this.saveHistoryLines();
    }

    protected void loadHistoryLines() {
        this.history = new ArrayList<String>();
        String historyData = Activator.getDefault().getPreferenceStore().getString(HISTORY_NAME_BASE + this.name);
        if (historyData != null && historyData.length() > 0) {
            String[] historyArray = historyData.split(";");
            for (int i = 0; i < historyArray.length; ++i) {
                historyArray[i] = new String(Base64.decode((byte[])historyArray[i].getBytes()));
            }
            this.history.addAll(Arrays.asList(historyArray));
        }
    }

    protected void saveHistoryLines() {
        String result = "";
        for (String str : this.history) {
            str = new String(Base64.encode((byte[])str.getBytes()));
            result = result + (result.length() == 0 ? str : ";" + str);
        }
        Activator.getDefault().getPreferenceStore().setValue(HISTORY_NAME_BASE + this.name, result);
    }
}

