/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.ui.debugmail;

import com.atlassian.theplugin.eclipse.ui.debugmail.IMailSettingsProvider;
import com.atlassian.theplugin.eclipse.util.PatternProvider;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MailDelivery {
    public static boolean sendMail(String to, String from, String subject, String body, String host, String port) throws Exception {
        if (host.length() == 0) {
            return true;
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.port", port);
        props.put("mail.smtp.auth", "false");
        Session session = Session.getDefaultInstance((Properties)props, null);
        session.setDebug(false);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(from));
        msg.setRecipients(Message.RecipientType.TO, (Address[])new InternetAddress[]{new InternetAddress(to)});
        msg.setSubject(subject);
        msg.setSentDate(new Date());
        msg.setText(body);
        String encoding = System.getProperty("file.encoding");
        encoding = encoding == null ? "" : "; charset=" + encoding;
        msg.setHeader("content-type", "text/html" + encoding);
        Transport.send((Message)msg);
        return true;
    }

    public static boolean sendMail(String messageBody, String operationName, String reportId, IMailSettingsProvider settingsProvider) throws Exception {
        String to = settingsProvider.getEmailTo();
        String from = settingsProvider.getEmailFrom();
        String subject = "[" + settingsProvider.getPluginName() + "] " + reportId + " - " + operationName + " Operation Failure Report";
        String host = settingsProvider.getHost();
        String port = settingsProvider.getPort();
        return MailDelivery.sendMail(to, from, subject, PatternProvider.replaceAll(messageBody, "\n", "<br>"), host, port);
    }

    public static boolean sendMailReport(String messageBody, String subject, String reportId, IMailSettingsProvider settingsProvider) throws Exception {
        String to = settingsProvider.getEmailTo();
        String from = settingsProvider.getEmailFrom();
        subject = "[" + settingsProvider.getPluginName() + "] " + reportId + " - " + subject;
        String host = settingsProvider.getHost();
        String port = settingsProvider.getPort();
        return MailDelivery.sendMail(to, from, subject, PatternProvider.replaceAll(messageBody, "\n", "<br>"), host, port);
    }
}

