/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.ui.composite.bamboo;

import com.atlassian.theplugin.eclipse.core.bamboo.IBambooServer;
import com.atlassian.theplugin.eclipse.preferences.Activator;
import com.atlassian.theplugin.eclipse.ui.composite.CredentialsComposite;
import com.atlassian.theplugin.eclipse.ui.dialog.DefaultDialog;
import com.atlassian.theplugin.eclipse.ui.panel.IPropertiesPanel;
import com.atlassian.theplugin.eclipse.ui.utility.UserInputHistory;
import com.atlassian.theplugin.eclipse.ui.verifier.AbstractVerifier;
import com.atlassian.theplugin.eclipse.ui.verifier.AbstractVerifierProxy;
import com.atlassian.theplugin.eclipse.ui.verifier.CompositeVerifier;
import com.atlassian.theplugin.eclipse.ui.verifier.IValidationManager;
import com.atlassian.theplugin.eclipse.ui.verifier.NonEmptyFieldVerifier;
import com.atlassian.theplugin.eclipse.ui.verifier.URLVerifier;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BambooServerPropertiesComposite
extends Composite
implements IPropertiesPanel {
    protected static final String URL_HISTORY_NAME = "bambooServerURL";
    protected Text serverLabel;
    protected Combo url;
    protected CompositeVerifier urlVerifier;
    protected UserInputHistory urlHistory;
    protected Button browse;
    protected Button useLocationButton;
    protected Button newLabelButton;
    protected CredentialsComposite credentialsComposite;
    protected IBambooServer bambooServer;
    protected String rootUrl;
    protected IValidationManager validationManager;
    protected IBambooServer credentialsInput;

    public BambooServerPropertiesComposite(Composite parent, int style, IValidationManager validationManager) {
        super(parent, style);
        this.validationManager = validationManager;
    }

    public void initialize() {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.marginHeight = 7;
        layout.verticalSpacing = 3;
        this.setLayout((Layout)layout);
        data = new GridData(1808);
        this.setLayoutData(data);
        Composite rootURLGroup = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        rootURLGroup.setLayout((Layout)layout);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        rootURLGroup.setLayoutData((Object)data);
        Label description = new Label(rootURLGroup, 0);
        data = new GridData(32);
        description.setLayoutData((Object)data);
        description.setText(Activator.getDefault().getResource("BambooServerPropertiesComposite.URL"));
        this.urlHistory = new UserInputHistory(URL_HISTORY_NAME);
        this.url = new Combo(rootURLGroup, 4);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 200;
        this.url.setLayoutData((Object)data);
        this.url.setVisibleItemCount(this.urlHistory.getDepth());
        this.url.setItems(this.urlHistory.getHistory());
        this.urlVerifier = new CompositeVerifier(){

            public boolean verify(Control input) {
                boolean retVal = super.verify(input);
                BambooServerPropertiesComposite.this.browse.setEnabled(retVal);
                return retVal;
            }
        };
        this.defineUrlVerifier(null);
        this.validationManager.attachTo((Control)this.url, this.urlVerifier);
        this.browse = new Button(rootURLGroup, 8);
        this.browse.setText(Activator.getDefault().getResource("Button.Browse"));
        data = new GridData(128);
        data.widthHint = DefaultDialog.computeButtonWidth(this.browse);
        this.browse.setLayoutData((Object)data);
        Group labelGroup = new Group((Composite)this, 0);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        layout = new GridLayout();
        labelGroup.setLayout((Layout)layout);
        labelGroup.setLayoutData((Object)data);
        labelGroup.setText(Activator.getDefault().getResource("BambooServerPropertiesComposite.Label"));
        this.useLocationButton = new Button((Composite)labelGroup, 16);
        this.useLocationButton.setLayoutData((Object)new GridData(768));
        this.useLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BambooServerPropertiesComposite.this.validationManager.validateContent();
                Button button = (Button)e.widget;
                BambooServerPropertiesComposite.this.serverLabel.setEnabled(!button.getSelection());
                if (!button.getSelection()) {
                    BambooServerPropertiesComposite.this.serverLabel.selectAll();
                } else {
                    BambooServerPropertiesComposite.this.serverLabel.setText("");
                }
            }
        });
        this.useLocationButton.setText(Activator.getDefault().getResource("BambooServerPropertiesComposite.UseURL"));
        this.newLabelButton = new Button((Composite)labelGroup, 16);
        this.newLabelButton.setLayoutData((Object)new GridData(768));
        this.newLabelButton.setText(Activator.getDefault().getResource("BambooServerPropertiesComposite.UseCustom"));
        this.serverLabel = new Text((Composite)labelGroup, 2052);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 200;
        this.serverLabel.setLayoutData((Object)data);
        this.validationManager.attachTo((Control)this.serverLabel, new AbstractVerifierProxy(new NonEmptyFieldVerifier(Activator.getDefault().getResource("BambooServerPropertiesComposite.UseCustom.Verifier"))){

            protected boolean isVerificationEnabled(Control input) {
                return BambooServerPropertiesComposite.this.newLabelButton.getSelection();
            }
        });
        this.serverLabel.setEnabled(false);
        this.credentialsComposite = new CredentialsComposite(this, 0);
        this.credentialsComposite.initialize();
        this.url.setFocus();
        this.resetChanges();
    }

    public void setBambooServer(IBambooServer location, String rootUrl) {
        this.credentialsInput = this.bambooServer = location;
        this.rootUrl = rootUrl;
    }

    public IBambooServer getBambooServer() {
        return this.bambooServer;
    }

    public String getLocationUrl() {
        return this.url.getText();
    }

    public void setCredentialsInput(IBambooServer location) {
        this.credentialsInput = location;
    }

    public void defineUrlVerifier(AbstractVerifier verifier) {
        String name = Activator.getDefault().getResource("BambooServerPropertiesComposite.URL.Verifier");
        this.urlVerifier.removeAll();
        this.urlVerifier.add(new URLVerifier(name));
        if (verifier != null) {
            this.urlVerifier.add(verifier);
        }
    }

    public void saveChanges() {
        if (this.useLocationButton.getSelection()) {
            this.bambooServer.setLabel(this.url.getText());
        } else {
            this.bambooServer.setLabel(this.serverLabel.getText());
        }
        String newUrl = this.url.getText();
        this.urlHistory.addLine(newUrl);
        this.bambooServer.setUrl(newUrl);
        this.credentialsComposite.getUserHistory().addLine(this.credentialsComposite.getUsername().getText());
        this.credentialsInput.setUsername(this.credentialsComposite.getUsername().getText());
        this.credentialsInput.setPassword(this.credentialsComposite.getPassword().getText());
        this.credentialsInput.setPasswordSaved(this.credentialsComposite.getSavePassword().getSelection());
    }

    public void resetChanges() {
        String url = this.bambooServer.getUrl();
        String string = url = url == null ? "" : url;
        if (this.bambooServer.getLabel() == null || this.bambooServer.getLabel().equalsIgnoreCase(this.bambooServer.getUrl())) {
            this.serverLabel.setText(url);
            this.useLocationButton.setSelection(true);
            this.newLabelButton.setSelection(false);
        } else {
            this.serverLabel.setText(this.bambooServer.getLabel());
            this.useLocationButton.setSelection(false);
            this.newLabelButton.setSelection(true);
        }
        this.serverLabel.setEnabled(!this.useLocationButton.getSelection());
        this.url.setText(url);
        String username = this.credentialsInput.getUsername();
        this.credentialsComposite.getUsername().setText(username == null ? "" : username);
        String password = this.credentialsInput.getPassword();
        this.credentialsComposite.getPassword().setText(password == null ? "" : password);
        this.credentialsComposite.getSavePassword().setSelection(this.credentialsInput.isPasswordSaved());
    }

    public void cancelChanges() {
    }
}

