/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.ui.composite;

import com.atlassian.theplugin.eclipse.preferences.Activator;
import com.atlassian.theplugin.eclipse.ui.debugmail.IMailSettingsProvider;
import com.atlassian.theplugin.eclipse.ui.debugmail.Reporter;
import com.atlassian.theplugin.eclipse.ui.dialog.DefaultDialog;
import com.atlassian.theplugin.eclipse.ui.panel.reporting.PreviewErrorReportPanel;
import com.atlassian.theplugin.eclipse.ui.panel.reporting.PreviewReportPanel;
import com.atlassian.theplugin.eclipse.ui.utility.UIMonitorUtil;
import com.atlassian.theplugin.eclipse.ui.utility.UserInputHistory;
import com.atlassian.theplugin.eclipse.ui.verifier.IValidationManager;
import com.atlassian.theplugin.eclipse.ui.verifier.NonEmptyFieldVerifier;
import com.atlassian.theplugin.eclipse.util.StringId;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ReportingComposite
extends Composite {
    public static final String MAIL_HISTORY = "mailHistory";
    public static final String USER_NAME_HISTORY = "userNameHistory";
    protected UserInputHistory mailHistory;
    protected UserInputHistory userNameHistory;
    protected Combo providersCombo;
    protected Text emailText;
    protected Text nameText;
    protected Text commentText;
    protected Button doNotShowAgainButton;
    protected boolean doNotShowAgain;
    protected String comment;
    protected String email;
    protected String name;
    protected String reportId;
    protected String report;
    protected String reportType;
    protected boolean isError;
    protected String pluginId;
    protected IStatus status;
    protected IMailSettingsProvider[] providers;
    protected int selectedProviderIdx;

    public ReportingComposite(Composite parent, String reportType, String pluginId, IStatus status, String optionName, boolean isError, IValidationManager manager) {
        super(parent, 0);
        this.isError = isError;
        this.reportType = reportType;
        this.pluginId = pluginId;
        this.status = status;
        this.reportId = StringId.generateRandom("Report ID", 5);
        this.providers = null;
        this.selectedProviderIdx = 0;
        this.createControls(optionName, manager);
    }

    public IMailSettingsProvider getMailSettingsProvider() {
        return this.providers[this.selectedProviderIdx];
    }

    public String getComment() {
        return this.comment;
    }

    public String getEmail() {
        return this.email;
    }

    public String getUserName() {
        return this.name;
    }

    public String getReportId() {
        return this.reportId;
    }

    public boolean isNotShowAgain() {
        return this.doNotShowAgain;
    }

    public void saveChanges() {
        this.comment = this.commentText.getText().trim();
        this.name = this.nameText.getText().trim();
        this.email = this.emailText.getText().trim();
        if (this.email.length() > 0) {
            this.mailHistory.addLine(this.email);
        } else {
            this.mailHistory.clear();
        }
        if (this.name.length() > 0) {
            this.userNameHistory.addLine(this.name);
        } else {
            this.userNameHistory.clear();
        }
        this.doNotShowAgain = this.doNotShowAgainButton.getSelection();
        this.report = this.saveReport();
    }

    public void cancelChanges() {
        this.doNotShowAgain = this.doNotShowAgainButton.getSelection();
    }

    private void createControls(String optionName, IValidationManager manager) {
        int widthHint;
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Composite composite = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        data = new GridData(768);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        Label description1 = new Label(composite, 0);
        data = new GridData();
        description1.setLayoutData((Object)data);
        description1.setText(Activator.getDefault().getResource("ReportingComposite.Product"));
        this.providersCombo = new Combo(composite, 2056);
        data = new GridData(768);
        this.providersCombo.setLayoutData((Object)data);
        Arrays.sort(this.providers, new Comparator<IMailSettingsProvider>(){

            @Override
            public int compare(IMailSettingsProvider first, IMailSettingsProvider second) {
                return first.getPluginName().compareTo(second.getPluginName());
            }
        });
        String[] names = new String[this.providers.length];
        for (int i = 0; i < this.providers.length; ++i) {
            names[i] = this.providers[i].getPluginName();
        }
        this.providersCombo.setItems(names);
        this.providersCombo.select(0);
        this.providersCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportingComposite.this.selectedProviderIdx = ReportingComposite.this.providersCombo.getSelectionIndex();
            }
        });
        Label description = new Label((Composite)this, 64);
        data = new GridData(772);
        data.widthHint = 200;
        data.heightHint = DefaultDialog.convertHeightInCharsToPixels((Control)this, this.isError ? 4 : 3);
        description.setLayoutData((Object)data);
        description.setText(Activator.getDefault().getResource(this.isError ? "ReportingComposite.ErrorHint" : "ReportingComposite.Hint"));
        composite = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        data = new GridData(768);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        this.mailHistory = new UserInputHistory(MAIL_HISTORY, 1);
        this.userNameHistory = new UserInputHistory(USER_NAME_HISTORY, 1);
        Label description2 = new Label(composite, 0);
        data = new GridData();
        description2.setLayoutData((Object)data);
        description2.setText(Activator.getDefault().getResource("ReportingComposite.EMail"));
        this.emailText = new Text(composite, 2048);
        data = new GridData(768);
        this.emailText.setLayoutData((Object)data);
        this.emailText.setFocus();
        String[] mailName = this.mailHistory.getHistory();
        if (mailName != null && mailName.length > 0) {
            this.emailText.setText(mailName[0]);
        }
        Label description3 = new Label(composite, 0);
        data = new GridData();
        description3.setLayoutData((Object)data);
        description3.setText(Activator.getDefault().getResource("ReportingComposite.Name"));
        ((GridData)description1.getLayoutData()).widthHint = widthHint = Math.max(description1.computeSize((int)-1, (int)-1).x, Math.max(description2.computeSize((int)-1, (int)-1).x, description3.computeSize((int)-1, (int)-1).x));
        ((GridData)description2.getLayoutData()).widthHint = widthHint;
        ((GridData)description3.getLayoutData()).widthHint = widthHint;
        this.nameText = new Text(composite, 2048);
        data = new GridData(768);
        this.nameText.setLayoutData((Object)data);
        String[] userName = this.userNameHistory.getHistory();
        if (userName != null && userName.length > 0) {
            this.nameText.setText(userName[0]);
        }
        Label commentLabel = new Label((Composite)this, 16384);
        data = new GridData();
        commentLabel.setLayoutData((Object)data);
        commentLabel.setText(Activator.getDefault().getResource("ReportingComposite.Comment"));
        this.commentText = new Text((Composite)this, 2626);
        data = new GridData(1808);
        data.heightHint = 100;
        this.commentText.setLayoutData((Object)data);
        if (mailName != null && mailName.length > 0) {
            this.commentText.setFocus();
        }
        if (manager != null) {
            manager.attachTo((Control)this.commentText, new NonEmptyFieldVerifier(Activator.getDefault().getResource("ReportingComposite.Comment.Verifier")));
        }
        Composite buttonsComposite = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 2;
        buttonsComposite.setLayout((Layout)layout);
        data = new GridData(768);
        buttonsComposite.setLayoutData((Object)data);
        this.doNotShowAgainButton = new Button(buttonsComposite, 32);
        data = new GridData(768);
        this.doNotShowAgainButton.setLayoutData((Object)data);
        this.doNotShowAgainButton.setSelection(false);
        if (optionName != null) {
            this.doNotShowAgainButton.setText(optionName);
        } else {
            this.doNotShowAgainButton.setVisible(false);
        }
        Button previewButton = new Button(buttonsComposite, 8);
        data = new GridData(896);
        previewButton.setText(Activator.getDefault().getResource("ReportingComposite.Preview"));
        data.widthHint = DefaultDialog.computeButtonWidth(previewButton);
        previewButton.setLayoutData((Object)data);
        previewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String report;
                PreviewReportPanel panel = null;
                if (ReportingComposite.this.isError) {
                    report = Reporter.formReport(ReportingComposite.this.getMailSettingsProvider(), ReportingComposite.this.status, ReportingComposite.this.pluginId, ReportingComposite.this.commentText.getText(), ReportingComposite.this.emailText.getText(), ReportingComposite.this.nameText.getText(), ReportingComposite.this.reportId);
                    panel = new PreviewErrorReportPanel(report);
                } else {
                    report = Reporter.formReport(ReportingComposite.this.getMailSettingsProvider(), ReportingComposite.this.commentText.getText(), ReportingComposite.this.emailText.getText(), ReportingComposite.this.nameText.getText(), ReportingComposite.this.reportId, ReportingComposite.this.isError);
                    String msg = Activator.getDefault().getResource("ReportingComposite.Preview.Title");
                    panel = new PreviewReportPanel(MessageFormat.format(msg, ReportingComposite.this.reportType), report);
                }
                DefaultDialog dialog = new DefaultDialog(UIMonitorUtil.getDisplay().getActiveShell(), panel);
                dialog.open();
            }
        });
    }

    public String saveReport() {
        String report = null;
        report = this.isError ? Reporter.formReport(this.getMailSettingsProvider(), this.status, this.pluginId, this.commentText.getText(), this.emailText.getText(), this.nameText.getText(), this.reportId) : Reporter.formReport(this.getMailSettingsProvider(), this.commentText.getText(), this.emailText.getText(), this.nameText.getText(), this.reportId, this.isError);
        return report;
    }

    public String getReport() {
        return this.report;
    }
}

