/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.ui.bamboo;

import com.atlassian.theplugin.eclipse.core.bamboo.IBambooServer;
import com.atlassian.theplugin.eclipse.core.operation.AbstractNonLockingOperation;
import com.atlassian.theplugin.eclipse.ui.bamboo.BambooFictiveNode;
import com.atlassian.theplugin.eclipse.ui.bamboo.BambooPlans;
import com.atlassian.theplugin.eclipse.ui.bamboo.BambooTreeViewer;
import com.atlassian.theplugin.eclipse.ui.bamboo.IBambooTreeNode;
import com.atlassian.theplugin.eclipse.util.PluginIcons;
import com.atlassian.theplugin.eclipse.view.bamboo.IDataTreeNode;
import com.atlassian.theplugin.eclipse.view.bamboo.IParentTreeNode;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class BambooServerNode
extends BambooFictiveNode
implements IBambooTreeNode,
IParentTreeNode,
IDataTreeNode {
    protected IBambooServer server;
    protected Object[] children;
    protected BambooTreeViewer bambooServerTree;

    public BambooServerNode(IBambooServer server) {
        this.server = server;
        this.refresh();
    }

    public void setViewer(BambooTreeViewer bambooServerTree) {
        this.bambooServerTree = bambooServerTree;
    }

    protected RefreshOperation getRefreshOperation(BambooTreeViewer viewer) {
        return new RefreshOperation(viewer);
    }

    public void refresh() {
        this.children = null;
    }

    public IBambooServer getBambooServer() {
        return this.server;
    }

    public Object getData() {
        return this.server;
    }

    public String getLabel(Object o) {
        return this.server.getLabel();
    }

    public boolean hasChildren() {
        return true;
    }

    public Object[] getChildren(Object o) {
        if (this.children == null) {
            ArrayList<BambooPlans> list = new ArrayList<BambooPlans>();
            list.add(new BambooPlans(this));
            this.children = list.toArray();
        }
        return this.children;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return ImageDescriptor.createFromImage((Image)PluginIcons.getImageRegistry().get("Bamboo"));
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof BambooServerNode) {
            return ((BambooServerNode)obj).server.equals(this.server);
        }
        return super.equals(obj);
    }

    protected class RefreshOperation
    extends AbstractNonLockingOperation {
        protected BambooTreeViewer viewer;

        public RefreshOperation(BambooTreeViewer viewer) {
            super("Operation.RefreshView");
            this.viewer = viewer;
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
                this.viewer.refresh(BambooServerNode.this, null, true);
            }
        }
    }
}

