/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.ui.action;

import com.atlassian.theplugin.eclipse.core.operation.AbstractNonLockingOperation;
import com.atlassian.theplugin.eclipse.core.operation.IActionOperation;
import com.atlassian.theplugin.eclipse.core.operation.LoggedOperation;
import com.atlassian.theplugin.eclipse.preferences.Activator;
import com.atlassian.theplugin.eclipse.ui.utility.DefaultOperationWrapperFactory;
import com.atlassian.theplugin.eclipse.ui.utility.ICancellableOperationWrapper;
import com.atlassian.theplugin.eclipse.ui.utility.IOperationWrapperFactory;
import com.atlassian.theplugin.eclipse.ui.utility.UIMonitorUtil;
import com.atlassian.theplugin.eclipse.util.ProgressMonitorUtility;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.actions.TeamAction;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class AbstractAction
extends TeamAction {
    private IWorkbenchWindow window;
    private Shell shell;
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                AbstractAction.this.checkSelection((IStructuredSelection)selection);
            }
        }
    };

    public final void run(final IAction action) {
        ProgressMonitorUtility.doTaskExternal(new AbstractNonLockingOperation("Operation.CallMenuAction"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                if (AbstractAction.this.isEnabled()) {
                    AbstractAction.this.runImpl(action);
                }
            }
        }, (IProgressMonitor)new NullProgressMonitor(), null);
    }

    public abstract boolean isEnabled();

    public abstract void runImpl(IAction var1);

    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
    }

    protected ICancellableOperationWrapper runBusy(IActionOperation operation) {
        return UIMonitorUtil.doTaskBusy(operation, this.getOperationWrapperFactory());
    }

    protected ICancellableOperationWrapper runNow(IActionOperation operation, boolean cancellable) {
        return UIMonitorUtil.doTaskNow(this.getShell(), operation, cancellable, this.getOperationWrapperFactory());
    }

    protected ICancellableOperationWrapper runScheduled(IActionOperation operation) {
        return UIMonitorUtil.doTaskScheduled(this.getTargetPart(), operation, this.getOperationWrapperFactory());
    }

    protected IOperationWrapperFactory getOperationWrapperFactory() {
        return new DefaultOperationWrapperFactory();
    }

    protected void handleException(Exception ex) {
        this.handle(ex, Activator.getDefault().getResource("Error.ActionFailed"), Activator.getDefault().getResource("Error.ActionFailed.Message"));
    }

    public void selectionChanged(IAction action, ISelection selection) {
        try {
            if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                action.setEnabled(false);
                return;
            }
            this.checkSelection((IStructuredSelection)selection);
            super.selectionChanged(action, selection);
        }
        catch (Throwable ex) {
            LoggedOperation.reportError(Activator.getDefault().getResource("Error.MenuEnablement"), ex);
        }
    }

    public Object[] getSelectedResources(Class c) {
        return TeamAction.getSelectedAdaptables((ISelection)this.getSelection(), (Class)c);
    }

    protected Shell getShell() {
        return this.shell != null ? this.shell : super.getShell();
    }

    public IWorkbenchWindow getWindow() {
        return this.window;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
        this.shell = this.window.getShell();
        this.window.getSelectionService().addPostSelectionListener(this.selectionListener);
    }

    public void dispose() {
        if (this.window != null) {
            this.window.getSelectionService().removePostSelectionListener(this.selectionListener);
        }
        super.dispose();
    }

    protected abstract void checkSelection(IStructuredSelection var1);

    protected abstract IStructuredSelection getSelection();
}

