/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.core.operation;

import com.atlassian.theplugin.eclipse.core.operation.AbstractActionOperation;
import com.atlassian.theplugin.eclipse.core.operation.IActionOperation;
import com.atlassian.theplugin.eclipse.core.operation.IConsoleStream;
import com.atlassian.theplugin.eclipse.util.ProgressMonitorUtility;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

public class CompositeOperation
extends AbstractActionOperation
implements IConsoleStream {
    protected List<Pair> operations = new ArrayList<Pair>();
    protected boolean checkWarnings;

    public CompositeOperation(String operationName) {
        this(operationName, false);
    }

    public CompositeOperation(String operationName, boolean checkWarnings) {
        super(operationName);
        this.checkWarnings = checkWarnings;
    }

    public void add(IActionOperation operation) {
        this.add(operation, null);
    }

    public void add(IActionOperation operation, IActionOperation[] dependsOnOperation) {
        operation.setConsoleStream(this);
        this.operations.add(new Pair(operation, dependsOnOperation));
    }

    public void remove(IActionOperation operation) {
        Iterator<Pair> it = this.operations.iterator();
        while (it.hasNext()) {
            Pair pair = it.next();
            if (pair.operation != operation) continue;
            if (operation.getConsoleStream() == this) {
                operation.setConsoleStream(null);
            }
            it.remove();
            break;
        }
    }

    public ISchedulingRule getSchedulingRule() {
        ISchedulingRule retVal = null;
        for (Pair pair : this.operations) {
            retVal = MultiRule.combine(retVal, (ISchedulingRule)pair.operation.getSchedulingRule());
        }
        return retVal;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        int j = 0;
        Iterator<Pair> it = this.operations.iterator();
        while (it.hasNext() && !monitor.isCanceled()) {
            Pair pair = it.next();
            boolean errorFound = false;
            if (pair.dependsOnOperation != null) {
                for (int i = 0; i < pair.dependsOnOperation.length; ++i) {
                    if (pair.dependsOnOperation[i].getStatus().getSeverity() != 4 && (!this.checkWarnings || pair.dependsOnOperation[i].getStatus().getSeverity() != 2) && pair.dependsOnOperation[i].getExecutionState() != 2) continue;
                    errorFound = true;
                    break;
                }
            }
            if (errorFound) continue;
            ProgressMonitorUtility.doTask(pair.operation, monitor, this.operations.size());
            this.reportStatus(pair.operation.getStatus());
            ProgressMonitorUtility.progress(monitor, j++, this.operations.size());
        }
    }

    public void markEnd() {
    }

    public void markStart(String data) {
    }

    public void write(int severity, String data) {
        this.writeToConsole(severity, data);
    }

    public void doComplexWrite(Runnable runnable) {
        this.complexWriteToConsole(runnable);
    }

    public void markCancelled() {
        this.writeCancelledToConsole();
    }

    protected class Pair {
        public IActionOperation operation;
        public IActionOperation[] dependsOnOperation;

        public Pair(IActionOperation operation, IActionOperation[] dependsOnOperation) {
            this.operation = operation;
            this.dependsOnOperation = dependsOnOperation;
        }
    }
}

