/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.actions.bamboo;

import com.atlassian.theplugin.commons.exception.ServerPasswordNotProvidedException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.eclipse.EclipseActionScheduler;
import com.atlassian.theplugin.eclipse.actions.bamboo.AbstractBambooAction;
import com.atlassian.theplugin.eclipse.editors.bamboo.BuildLogEditorInput;
import com.atlassian.theplugin.eclipse.util.PluginIcons;
import com.atlassian.theplugin.eclipse.view.bamboo.BambooBuildAdapterEclipse;
import com.atlassian.theplugin.eclipse.view.bamboo.BambooToolWindow;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ShowBuildLogAction
extends AbstractBambooAction {
    private static final String SHOW_BUILD_LOG = "Show Build Log";

    public ShowBuildLogAction(BambooToolWindow bambooToolWindowTable) {
        super(bambooToolWindowTable);
    }

    public void run() {
        final BambooBuildAdapterEclipse build = this.getBuild();
        Job labelBuild = new Job("Retrieving build log"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ShowBuildLogAction.this.setUIMessage("Retrieving build log");
                    final byte[] log = ShowBuildLogAction.this.bambooFacade.getBuildLogs(build.getServer(), build.getBuildKey(), build.getBuildNumber());
                    EclipseActionScheduler.getInstance().invokeLater(new Runnable(){

                        public void run() {
                            BuildLogEditorInput editorInput = new BuildLogEditorInput(new String(log), build.getBuildKey() + "-" + build.getBuildNumber());
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            IWorkbenchPage page = window.getActivePage();
                            try {
                                page.openEditor((IEditorInput)editorInput, "com.atlassian.theplugin.eclipse.editors.bamboo.LogEditor");
                            }
                            catch (PartInitException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    ShowBuildLogAction.this.setUIMessage("");
                }
                catch (ServerPasswordNotProvidedException e) {
                    ShowBuildLogAction.this.setUIMessage("Error getting build log. Password not provided for server");
                }
                catch (RemoteApiException e) {
                    ShowBuildLogAction.this.setUIMessage("Error getting build log. " + e.getMessage());
                }
                return Status.OK_STATUS;
            }
        };
        labelBuild.setPriority(20);
        labelBuild.schedule();
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.createFromImage((Image)PluginIcons.getImageRegistry().get("Get_log_bamboo_build"));
    }

    public String getToolTipText() {
        return SHOW_BUILD_LOG;
    }
}

