/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.view.popup;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class SwtUtil {
    public static final long FADE_RESCHEDULE_DELAY = 80L;
    public static final int FADE_IN_INCREMENT = 15;
    public static final int FADE_OUT_INCREMENT = -20;

    private SwtUtil() {
    }

    public static boolean setAlpha(Shell shell, int value) {
        Method method = null;
        try {
            method = shell.getClass().getMethod("setAlpha", Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)shell, value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getAlpha(Shell shell) {
        Method method = null;
        try {
            method = shell.getClass().getMethod("getAlpha", new Class[0]);
            method.setAccessible(true);
            return (Integer)method.invoke((Object)shell, new Object[0]);
        }
        catch (Exception e) {
            return 255;
        }
    }

    public static FadeJob fadeIn(Shell shell, IFadeListener listener) {
        return new FadeJob(shell, 15, 80L, listener);
    }

    public static FadeJob fadeOut(Shell shell, IFadeListener listener) {
        return new FadeJob(shell, -20, 80L, listener);
    }

    public static void fade(Shell shell, boolean fadeIn, int increment, int speed) {
        try {
            Method method = shell.getClass().getMethod("setAlpha", Integer.TYPE);
            method.setAccessible(true);
            if (fadeIn) {
                for (int i = 0; i <= 255; i += increment) {
                    method.invoke((Object)shell, i);
                    try {
                        Thread.sleep(speed);
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                method.invoke((Object)shell, 255);
            } else {
                for (int i = 244; i >= 0; i -= increment) {
                    method.invoke((Object)shell, i);
                    try {
                        Thread.sleep(speed);
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                method.invoke((Object)shell, 0);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static interface IFadeListener {
        public void faded(Shell var1, int var2);
    }

    public static class FadeJob
    extends Job {
        private static final int FADE_CONSTANT = 255;
        private final Shell shell;
        private final int increment;
        private volatile boolean stopped;
        private volatile int currentAlpha;
        private final long delay;
        private final IFadeListener fadeListener;

        public FadeJob(Shell shell, int increment, long delay, IFadeListener fadeListener) {
            super("Fading");
            if (increment < -255 || increment == 0 || increment > 255) {
                throw new IllegalArgumentException("-255 <= increment <= 255 && increment != 0");
            }
            if (delay < 1L) {
                throw new IllegalArgumentException("delay must be > 0");
            }
            this.currentAlpha = SwtUtil.getAlpha(shell);
            this.shell = shell;
            this.increment = increment;
            this.delay = delay;
            this.fadeListener = fadeListener;
            this.setSystem(true);
            this.schedule(delay);
        }

        protected void canceling() {
            this.stopped = true;
        }

        private void reschedule() {
            if (this.stopped) {
                return;
            }
            this.schedule(this.delay);
        }

        public void cancelAndWait(final boolean setAlpha) {
            if (this.stopped) {
                return;
            }
            this.cancel();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (setAlpha) {
                        SwtUtil.setAlpha(FadeJob.this.shell, FadeJob.this.getLastAlpha());
                    }
                }
            });
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.stopped) {
                return Status.OK_STATUS;
            }
            this.currentAlpha += this.increment;
            if (this.currentAlpha <= 0) {
                this.currentAlpha = 0;
            } else if (this.currentAlpha >= 255) {
                this.currentAlpha = 255;
            }
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (FadeJob.this.stopped) {
                        return;
                    }
                    if (FadeJob.this.shell.isDisposed()) {
                        FadeJob.this.stopped = true;
                        return;
                    }
                    if (!SwtUtil.setAlpha(FadeJob.this.shell, FadeJob.this.currentAlpha)) {
                        FadeJob.this.currentAlpha = FadeJob.this.getLastAlpha();
                        SwtUtil.setAlpha(FadeJob.this.shell, FadeJob.this.currentAlpha);
                        FadeJob.this.stopped = true;
                    }
                    if (FadeJob.this.fadeListener != null) {
                        FadeJob.this.fadeListener.faded(FadeJob.this.shell, FadeJob.this.currentAlpha);
                    }
                }
            });
            if (this.currentAlpha == 0 || this.currentAlpha == 255) {
                this.stopped = true;
            }
            this.reschedule();
            return Status.OK_STATUS;
        }

        private int getLastAlpha() {
            return this.increment < 0 ? 0 : 255;
        }
    }
}

