/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class SubProgressMonitorWithInfo
extends SubProgressMonitor {
    protected int currentProgress;
    protected double unknownProgress;
    protected int total;
    protected long lastTime;

    public SubProgressMonitorWithInfo(IProgressMonitor monitor, int ticks) {
        super(monitor, ticks);
        this.total = ticks;
        this.lastTime = 0L;
    }

    public SubProgressMonitorWithInfo(IProgressMonitor monitor, int ticks, int style) {
        super(monitor, ticks, style);
        this.total = ticks;
        this.lastTime = 0L;
    }

    public void beginTask(String name, int totalWork) {
        this.currentProgress = 0;
        this.unknownProgress = 0.0;
        super.beginTask(name, totalWork);
    }

    public void setTaskName(String name) {
        long time = System.currentTimeMillis();
        if (this.lastTime == 0L || time - this.lastTime >= 250L) {
            this.lastTime = time;
            super.setTaskName(name);
        }
    }

    public void subTask(String name) {
        long time = System.currentTimeMillis();
        if (this.lastTime == 0L || time - this.lastTime >= 250L) {
            this.lastTime = time;
            super.subTask(name);
        }
    }

    public void worked(int work) {
        this.currentProgress += work;
        super.worked(work);
    }

    public void unknownProgress(int current) {
        this.unknownProgress += 1.0 / ((this.unknownProgress + 1.0) * (this.unknownProgress > 75.0 ? this.unknownProgress : 1.0));
        int offset = (int)(this.unknownProgress - (double)this.currentProgress);
        this.worked(offset);
    }

    public int getCurrentProgress() {
        return this.currentProgress;
    }
}

