/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.ui.verifier;

import com.atlassian.theplugin.eclipse.ui.verifier.AbstractVerifier;
import com.atlassian.theplugin.eclipse.ui.verifier.IVerifierListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeVerifier
extends AbstractVerifier
implements IVerifierListener {
    protected List<AbstractVerifier> verifiers = new ArrayList<AbstractVerifier>();

    public List<AbstractVerifier> getVerifiers() {
        return this.verifiers;
    }

    public void add(AbstractVerifier verifier) {
        if (!this.verifiers.contains(verifier)) {
            verifier.addVerifierListener(this);
            this.verifiers.add(verifier);
        }
    }

    public void remove(AbstractVerifier verifier) {
        if (this.verifiers.remove(verifier)) {
            verifier.removeVerifierListener(this);
        }
    }

    public void removeAll() {
        Iterator<AbstractVerifier> it = this.verifiers.iterator();
        while (it.hasNext()) {
            it.next().removeVerifierListener(this);
        }
        this.verifiers.clear();
    }

    @Override
    public boolean verify(Control input) {
        this.hasWarning = false;
        for (AbstractVerifier iVer : this.verifiers) {
            if (iVer.verify(input)) continue;
            return false;
        }
        if (!this.hasWarning) {
            this.fireOk();
        }
        return true;
    }

    @Override
    public void hasError(String errorReason) {
        this.fireError(errorReason);
    }

    @Override
    public void hasWarning(String warningReason) {
        this.fireWarning(warningReason);
    }

    @Override
    public void hasNoError() {
    }

    @Override
    protected String getErrorMessage(Control input) {
        return null;
    }

    @Override
    protected String getWarningMessage(Control input) {
        return null;
    }
}

