/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.ui.verifier;

import com.atlassian.theplugin.eclipse.preferences.Activator;
import com.atlassian.theplugin.eclipse.ui.verifier.IVerifierListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractVerifier {
    protected List<IVerifierListener> listeners = new ArrayList<IVerifierListener>();
    protected boolean filledRight = false;
    protected boolean hasWarning = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addVerifierListener(IVerifierListener listener) {
        List<IVerifierListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVerifierListener(IVerifierListener listener) {
        List<IVerifierListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public boolean isFilledRight() {
        return this.filledRight;
    }

    public boolean hasWarning() {
        return this.hasWarning;
    }

    public boolean verify(Control input) {
        String msg = this.getErrorMessage(input);
        if (msg != null) {
            this.fireError(msg);
            return false;
        }
        msg = this.getWarningMessage(input);
        if (msg != null) {
            this.fireWarning(msg);
        } else {
            this.fireOk();
        }
        return true;
    }

    protected abstract String getErrorMessage(Control var1);

    protected abstract String getWarningMessage(Control var1);

    protected String getText(Control input) {
        if (input instanceof Text) {
            return ((Text)input).getText();
        }
        if (input instanceof Combo) {
            return ((Combo)input).getText();
        }
        String message = Activator.getDefault().getResource("Verifier.Abstract");
        throw new RuntimeException(MessageFormat.format(message, this.getClass().getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireError(String errorReason) {
        this.filledRight = false;
        this.hasWarning = false;
        Object[] listeners = null;
        List<IVerifierListener> list = this.listeners;
        synchronized (list) {
            listeners = this.listeners.toArray();
        }
        for (int i = listeners.length - 1; i >= 0; --i) {
            ((IVerifierListener)listeners[i]).hasError(errorReason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireWarning(String warningReason) {
        this.filledRight = true;
        this.hasWarning = true;
        Object[] listeners = null;
        List<IVerifierListener> list = this.listeners;
        synchronized (list) {
            listeners = this.listeners.toArray();
        }
        for (int i = listeners.length - 1; i >= 0; --i) {
            ((IVerifierListener)listeners[i]).hasWarning(warningReason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireOk() {
        this.filledRight = true;
        this.hasWarning = false;
        Object[] listeners = null;
        List<IVerifierListener> list = this.listeners;
        synchronized (list) {
            listeners = this.listeners.toArray();
        }
        for (int i = listeners.length - 1; i >= 0; --i) {
            ((IVerifierListener)listeners[i]).hasNoError();
        }
    }
}

