/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.ui.bamboo;

import com.atlassian.theplugin.commons.bamboo.BambooPlan;
import com.atlassian.theplugin.eclipse.core.operation.CompositeOperation;
import com.atlassian.theplugin.eclipse.core.operation.IActionOperation;
import com.atlassian.theplugin.eclipse.core.operation.LoggedOperation;
import com.atlassian.theplugin.eclipse.preferences.Activator;
import com.atlassian.theplugin.eclipse.ui.RefreshPending;
import com.atlassian.theplugin.eclipse.ui.bamboo.BambooErrorNode;
import com.atlassian.theplugin.eclipse.ui.bamboo.BambooFictiveNode;
import com.atlassian.theplugin.eclipse.ui.bamboo.BambooPlanNode;
import com.atlassian.theplugin.eclipse.ui.bamboo.BambooServerNode;
import com.atlassian.theplugin.eclipse.ui.bamboo.BambooTreeViewer;
import com.atlassian.theplugin.eclipse.ui.bamboo.IBambooTreeNode;
import com.atlassian.theplugin.eclipse.ui.operation.bamboo.GetBambooPlansChildrenOperation;
import com.atlassian.theplugin.eclipse.ui.utility.DefaultOperationWrapperFactory;
import com.atlassian.theplugin.eclipse.ui.utility.UIMonitorUtil;
import com.atlassian.theplugin.eclipse.util.PluginIcons;
import com.atlassian.theplugin.eclipse.view.bamboo.IDataTreeNode;
import com.atlassian.theplugin.eclipse.view.bamboo.IParentTreeNode;
import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class BambooPlans
extends BambooFictiveNode
implements IBambooTreeNode,
IDataTreeNode,
IParentTreeNode {
    private BambooServerNode server;
    private GetBambooPlansChildrenOperation childrenOp;
    private BambooTreeViewer bambooTree;

    public BambooPlans(BambooServerNode server) {
        this.server = server;
    }

    public Object[] getChildren(Object o) {
        if (this.childrenOp != null) {
            Object[] objectArray;
            Object[] retVal = this.wrapChildren(this.childrenOp.getChildren());
            if (retVal == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.childrenOp.getExecutionState() != 1 ? new RefreshPending(this) : new BambooErrorNode(this.childrenOp.getStatus());
            } else {
                objectArray = retVal;
            }
            return objectArray;
        }
        this.childrenOp = new GetBambooPlansChildrenOperation(this.server.getBambooServer());
        CompositeOperation op = new CompositeOperation(this.childrenOp.getId());
        op.add(this.childrenOp);
        op.add(this.server.getRefreshOperation(this.bambooTree));
        UIMonitorUtil.doTaskScheduled(op, new DefaultOperationWrapperFactory(){

            public IActionOperation getLogged(IActionOperation operation) {
                return new LoggedOperation(operation);
            }
        });
        return new Object[]{new RefreshPending(this)};
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return ImageDescriptor.createFromImage((Image)PluginIcons.getImageRegistry().get("Bamboo"));
    }

    public String getLabel(Object o) {
        return Activator.getDefault().getResource("BambooServerView.Model.Plans");
    }

    public void refresh() {
        this.childrenOp = null;
    }

    public boolean hasChildren() {
        return true;
    }

    public Object getData() {
        return null;
    }

    protected BambooPlanNode[] wrapChildren(BambooPlan[] plans) {
        if (plans == null) {
            return null;
        }
        ArrayList<BambooPlanNode> children = new ArrayList<BambooPlanNode>(plans.length);
        if (plans != null) {
            for (BambooPlan plan : plans) {
                children.add(new BambooPlanNode(plan));
            }
        }
        return children.toArray(new BambooPlanNode[children.size()]);
    }

    public void setViewer(BambooTreeViewer viewer) {
        this.bambooTree = viewer;
    }
}

