/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.preferences;

import com.atlassian.theplugin.commons.bamboo.BambooServerFacade;
import com.atlassian.theplugin.commons.bamboo.BambooServerFacadeImpl;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.commons.util.Logger;
import com.atlassian.theplugin.eclipse.EclipseActionScheduler;
import com.atlassian.theplugin.eclipse.preferences.Activator;
import com.atlassian.theplugin.eclipse.preferences.PreferencePageServers;
import com.atlassian.theplugin.eclipse.util.PluginUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;

public class TestConnection
extends FieldEditor {
    private PreferencePageServers parentPreferencePage;

    public TestConnection(Composite parent, PreferencePageServers preferencePageServers) {
        this.createControl(parent);
        this.parentPreferencePage = preferencePageServers;
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label label = this.getLabelControl(parent);
        GridData gdLabel = new GridData();
        gdLabel.verticalAlignment = 1;
        label.setLayoutData((Object)gdLabel);
        Button testConnectionButton = this.getTestConnectionButton(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        gd.horizontalAlignment = 3;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        testConnectionButton.setLayoutData((Object)gd);
    }

    private Button getTestConnectionButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Test Connection");
        button.setToolTipText("Test connection using form values");
        button.addMouseListener((MouseListener)new TestConnectionListener());
        return button;
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }

    public int getNumberOfControls() {
        return 1;
    }

    private class TestConnectionListener
    extends MouseAdapter {
        private TestConnectionListener() {
        }

        public void mouseUp(MouseEvent e) {
            super.mouseUp(e);
            final String url = TestConnection.this.parentPreferencePage.getBambooUrl();
            final String user = TestConnection.this.parentPreferencePage.getUserName();
            final String password = TestConnection.this.parentPreferencePage.getPassword();
            Job job = new Job("Atlassian test connection"){

                protected IStatus run(IProgressMonitor monitor) {
                    int icon;
                    BambooServerFacade bambooFacade = BambooServerFacadeImpl.getInstance((Logger)PluginUtil.getLogger());
                    String message = "";
                    String title = "";
                    try {
                        bambooFacade.testServerConnection(url, user, password);
                        icon = 2;
                        message = "Connected successfully";
                        title = "Connection OK";
                    }
                    catch (RemoteApiException ex) {
                        icon = 1;
                        message = ex.getMessage();
                        title = "Connection Error";
                    }
                    final String messageFinal = message;
                    final String titleFinal = title;
                    final int iconFinal = icon;
                    EclipseActionScheduler.getInstance().invokeLater(new Runnable(){

                        public void run() {
                            MessageBox dialog = new MessageBox(Activator.getDefault().getShell(), 0x20 | iconFinal);
                            dialog.setMessage(messageFinal);
                            dialog.setText(titleFinal);
                            dialog.open();
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }
}

