/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.view.bamboo;

import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import com.atlassian.theplugin.commons.bamboo.BambooStatusListener;
import com.atlassian.theplugin.commons.bamboo.BuildStatus;
import com.atlassian.theplugin.eclipse.preferences.Activator;
import com.atlassian.theplugin.eclipse.util.PluginIcons;
import com.atlassian.theplugin.eclipse.view.bamboo.BambooBuildAdapterEclipse;
import com.atlassian.theplugin.eclipse.view.bamboo.BambooToolWindow;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PartInitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BambooToolWindowContent
implements BambooStatusListener {
    private Collection<BambooBuildAdapterEclipse> buildStatuses = new ArrayList<BambooBuildAdapterEclipse>();
    private Table table;
    private TableViewer tableViewer;
    private final BambooToolWindow viewPart;

    public BambooToolWindowContent(Composite parent, final BambooToolWindow viewPart) {
        int[] order;
        int i;
        this.viewPart = viewPart;
        int style = 101124;
        this.tableViewer = new TableViewer(parent, style);
        this.tableViewer.setContentProvider((IContentProvider)new BambooContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new BambooLabelProvider());
        this.tableViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    viewPart.disableBambooBuildActions();
                } else if (BambooToolWindowContent.this.getBuild(event).isBamboo2()) {
                    viewPart.enableBamboo2BuildActions();
                    viewPart.enableBambooBuildActions();
                } else {
                    viewPart.enableBambooBuildActions();
                }
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BambooBuildAdapterEclipse build = BambooToolWindowContent.this.getBuild(event);
                try {
                    Activator.getDefault().getWorkbench().getBrowserSupport().createBrowser(128, "browserId", "name", "tooltip").openURL(new URL(build.getBuildResultUrl()));
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        });
        this.table = this.tableViewer.getTable();
        BambooTableColumnListener columnListener = new BambooTableColumnListener();
        List<Integer> configColumnsWidth = Activator.getDefault().getPluginConfiguration().getBambooTabConfiguration().getColumnsWidth();
        for (i = 0; i < Column.values().length; ++i) {
            Column column = Column.values()[i];
            TableColumn tableColumn = new TableColumn(this.table, 16384);
            tableColumn.setText(column.columnName());
            tableColumn.setWidth(column.columnWidth());
            tableColumn.setMoveable(true);
            tableColumn.setResizable(true);
        }
        if (configColumnsWidth.size() == Column.values().length) {
            for (i = 0; i < configColumnsWidth.size(); ++i) {
                this.table.getColumn(i).setWidth(configColumnsWidth.get(i).intValue());
            }
        }
        if ((order = Activator.getDefault().getPluginConfiguration().getBambooTabConfiguration().getColumnsOrder()).length == Column.values().length) {
            this.table.setColumnOrder(order);
        }
        for (TableColumn column : this.table.getColumns()) {
            column.addControlListener((ControlListener)columnListener);
        }
        this.tableViewer.setInput(this.buildStatuses);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
    }

    public void updateBuildStatuses(Collection<BambooBuild> buildStatuses) {
        Date pollingTime = new Date();
        this.buildStatuses.clear();
        for (BambooBuild build : buildStatuses) {
            this.buildStatuses.add(new BambooBuildAdapterEclipse(build));
            pollingTime = build.getPollingTime();
        }
        this.tableViewer.setInput(buildStatuses);
        this.viewPart.setHeaderText("Last polling time: " + pollingTime.toString());
    }

    public void resetState() {
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    private BambooBuildAdapterEclipse getBuild(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        BambooBuildAdapterEclipse build = (BambooBuildAdapterEclipse)((Object)selection.getFirstElement());
        return build;
    }

    private BambooBuildAdapterEclipse getBuild(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        BambooBuildAdapterEclipse build = (BambooBuildAdapterEclipse)((Object)selection.getFirstElement());
        return build;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Column {
        BUILD_STATUS("ST", 30),
        BUILD_KEY("Build Plan", 80),
        BUILD_NUMBER("Build Number", 100),
        PROJECT_KEY("Project", 100),
        BUILD_DATE("Build Date", 100),
        PASSED_TESTS("Tests", 100),
        BUILD_REASON("Reason", 100),
        SERVER("Server", 100),
        MESSAGE("Message", 300);

        private String columnName;
        private int columnWidth;

        private Column(String columnName, int columnWidth) {
            this.columnName = columnName;
            this.columnWidth = columnWidth;
        }

        public static Column valueOfAlias(String text) {
            for (Column column : Column.values()) {
                if (!column.columnName().equals(text)) continue;
                return column;
            }
            return null;
        }

        public String columnName() {
            return this.columnName;
        }

        public int columnWidth() {
            return this.columnWidth;
        }
    }

    private class BambooLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private BambooLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            BambooBuildAdapterEclipse build = (BambooBuildAdapterEclipse)((Object)element);
            Column column = Column.valueOfAlias(BambooToolWindowContent.this.table.getColumn(columnIndex).getText());
            if (column == Column.BUILD_STATUS) {
                switch (build.getStatus()) {
                    case BUILD_SUCCEED: {
                        return PluginIcons.getImageRegistry().get(BuildStatus.BUILD_SUCCEED.toString());
                    }
                    case BUILD_FAILED: {
                        return PluginIcons.getImageRegistry().get(BuildStatus.BUILD_FAILED.toString());
                    }
                    case UNKNOWN: {
                        return PluginIcons.getImageRegistry().get(BuildStatus.UNKNOWN.toString());
                    }
                }
                return null;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            BambooBuildAdapterEclipse build = (BambooBuildAdapterEclipse)((Object)element);
            Column column = Column.valueOfAlias(BambooToolWindowContent.this.table.getColumn(columnIndex).getText());
            switch (column) {
                case BUILD_DATE: {
                    return build.getBuildTimeFormated();
                }
                case BUILD_NUMBER: {
                    return build.getBuildNumber();
                }
                case BUILD_KEY: {
                    return build.getBuildKey();
                }
                case BUILD_STATUS: {
                    return "";
                }
                case PROJECT_KEY: {
                    return build.getProjectName();
                }
                case BUILD_REASON: {
                    return build.getBuildReason();
                }
                case MESSAGE: {
                    return build.getMessage();
                }
                case PASSED_TESTS: {
                    return build.getTestsPassedSummary();
                }
                case SERVER: {
                    return build.getServerName();
                }
            }
            return "";
        }
    }

    private class BambooContentProvider
    implements IStructuredContentProvider {
        private BambooContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return BambooToolWindowContent.this.buildStatuses.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class BambooTableColumnListener
    implements ControlListener {
        private BambooTableColumnListener() {
        }

        public void controlMoved(ControlEvent e) {
            Activator.getDefault().getPluginConfiguration().getBambooTabConfiguration().setColumnsOrder(BambooToolWindowContent.this.table.getColumnOrder());
        }

        public void controlResized(ControlEvent e) {
            ArrayList<Integer> columnsWidth = new ArrayList<Integer>(BambooToolWindowContent.this.table.getColumns().length);
            for (TableColumn column : BambooToolWindowContent.this.table.getColumns()) {
                columnsWidth.add(column.getWidth());
            }
            Activator.getDefault().getPluginConfiguration().getBambooTabConfiguration().setColumnsWidth(columnsWidth);
        }
    }
}

