/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class PatternProvider {
    private static int MAX_CACHE_SIZE = 100;
    private static LinkedHashMap<String, Pattern> patterns = new LinkedHashMap<String, Pattern>(){
        private static final long serialVersionUID = 2921759287651173337L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Pattern> eldest) {
            return this.size() > MAX_CACHE_SIZE;
        }
    };

    public static String replaceAll(String strSource, String strPattern, String strReplacement) {
        return PatternProvider.getPattern(strPattern).matcher(strSource).replaceAll(strReplacement);
    }

    public static synchronized Pattern getPattern(String strPattern) {
        Pattern patternReturn = patterns.get(strPattern);
        if (patternReturn == null) {
            patternReturn = Pattern.compile(strPattern);
            patterns.put(strPattern, patternReturn);
        }
        return patternReturn;
    }

    private PatternProvider() {
    }
}

