/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.ui.verifier;

import com.atlassian.theplugin.eclipse.preferences.Activator;
import com.atlassian.theplugin.eclipse.ui.verifier.AbstractFormattedVerifier;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.swt.widgets.Control;

public class URLVerifier
extends AbstractFormattedVerifier {
    protected static final String ERROR_REASON = "$ERROR_REASON$";
    protected static String ERROR_MESSAGE_SHORT;
    protected static String ERROR_MESSAGE_FULL;

    public URLVerifier(String fieldName) {
        super(fieldName);
        ERROR_MESSAGE_SHORT = Activator.getDefault().getResource("Verifier.URL.Short");
        ERROR_MESSAGE_SHORT = MessageFormat.format(ERROR_MESSAGE_SHORT, "$FIELD_NAME$");
        ERROR_MESSAGE_FULL = Activator.getDefault().getResource("Verifier.URL.Full");
        ERROR_MESSAGE_FULL = MessageFormat.format(ERROR_MESSAGE_FULL, "$FIELD_NAME$", ERROR_REASON);
    }

    protected String getErrorMessageImpl(Control input) {
        String url = this.getText(input);
        try {
            URL svnUrl = new URL(url);
            String host = svnUrl.getHost();
            if (!host.matches("[a-zA-Z0-9_\\-]+(?:\\.[a-zA-Z0-9_\\-]+)*") && host.length() > 0 || host.length() == 0 && !"file".equals(svnUrl.getProtocol())) {
                this.setPlaceHolder(ERROR_REASON, Activator.getDefault().getResource("Verifier.URL.NoHost"));
                return ERROR_MESSAGE_FULL;
            }
            return null;
        }
        catch (Exception ex) {
            this.setPlaceHolder(ERROR_REASON, ex.getMessage());
            return ex.getMessage() == null ? ERROR_MESSAGE_SHORT : ERROR_MESSAGE_FULL;
        }
    }

    protected String getWarningMessageImpl(Control input) {
        return null;
    }
}

