/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.ui.panel.reporting;

import com.atlassian.theplugin.eclipse.preferences.Activator;
import com.atlassian.theplugin.eclipse.ui.composite.ReportingComposite;
import com.atlassian.theplugin.eclipse.ui.debugmail.IMailSettingsProvider;
import com.atlassian.theplugin.eclipse.ui.dialog.DefaultDialog;
import com.atlassian.theplugin.eclipse.ui.panel.AbstractAdvancedDialogPanel;
import com.atlassian.theplugin.eclipse.ui.panel.IDialogManagerEx;
import com.atlassian.theplugin.eclipse.ui.panel.reporting.PreviewReportPanel;
import com.atlassian.theplugin.eclipse.ui.utility.UIMonitorUtil;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ErrorCancelPanel
extends AbstractAdvancedDialogPanel {
    protected static final int ERROR_PANEL_TYPE = 0;
    protected static final int CANCEL_PANEL_TYPE = 1;
    protected ReportingComposite reportingComposite;
    protected Text errorTextField;
    protected String optionName;
    protected String simpleMessage;
    protected String advancedMessage;
    protected boolean isSimple;
    protected int panelType;
    protected boolean sendMail;
    protected IStatus errorStatus;
    protected String plugin;
    protected String originalReport;

    public ErrorCancelPanel(String title, int numberOfErrors, String simpleMessage, String advancedMessage, boolean sendMail, String optionName) {
        this(0, numberOfErrors, title, simpleMessage, advancedMessage, sendMail, optionName);
    }

    public ErrorCancelPanel(String title, String simpleMessage, String advancedMessage, boolean sendMail, String optionName) {
        this(1, 0, title, simpleMessage, advancedMessage, sendMail, optionName);
    }

    public ErrorCancelPanel(String title, int numberOfErrors, String simpleMessage, String advancedMessage, boolean sendMail, String optionName, IStatus errorStatus, String plugin) {
        this(0, numberOfErrors, title, simpleMessage, advancedMessage, sendMail, optionName);
        this.errorStatus = errorStatus;
        this.plugin = plugin;
    }

    public ErrorCancelPanel(String title, int numberOfErrors, String simpleMessage, String advancedMessage, boolean sendMail, String optionName, IStatus errorStatus, String plugin, String originalReport) {
        this(0, numberOfErrors, title, simpleMessage, advancedMessage, sendMail, optionName);
        this.errorStatus = errorStatus;
        this.plugin = plugin;
        this.originalReport = originalReport;
    }

    protected ErrorCancelPanel(int panelType, int numberOfErrors, String title, String simpleMessage, String advancedMessage, boolean sendMail, String optionName) {
        String[] stringArray;
        if (sendMail) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = Activator.getDefault().getResource("ErrorCancelPanel.Send");
            stringArray = stringArray2;
            stringArray2[1] = Activator.getDefault().getResource("ErrorCancelPanel.DontSend");
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = IDialogConstants.OK_LABEL;
        }
        super(stringArray, new String[]{Activator.getDefault().getResource("Button.Advanced")});
        this.panelType = panelType;
        this.sendMail = sendMail;
        this.dialogTitle = Activator.getDefault().getResource(panelType == 0 ? "ErrorCancelPanel.Title.Failed" : "ErrorCancelPanel.Title.Cancelled");
        if (title == null || title.length() == 0) {
            this.dialogDescription = Activator.getDefault().getResource(panelType == 0 ? "ErrorCancelPanel.Description.Failed.Empty" : "ErrorCancelPanel.Description.Cancelled.Empty");
        } else {
            this.dialogDescription = Activator.getDefault().getResource(panelType == 0 ? "ErrorCancelPanel.Description.Failed" : "ErrorCancelPanel.Description.Cancelled");
            this.dialogDescription = MessageFormat.format(this.dialogDescription, title);
        }
        if (sendMail) {
            this.defaultMessage = Activator.getDefault().getResource("ErrorCancelPanel.Message.Send");
        } else if (panelType == 0) {
            if (numberOfErrors == 1) {
                this.defaultMessage = Activator.getDefault().getResource("ErrorCancelPanel.Message.DontSend.Single");
            } else {
                this.defaultMessage = Activator.getDefault().getResource("ErrorCancelPanel.Message.DontSend.Multi");
                this.defaultMessage = MessageFormat.format(this.defaultMessage, String.valueOf(numberOfErrors));
            }
        } else {
            this.defaultMessage = Activator.getDefault().getResource("ErrorCancelPanel.Message.DontSend");
        }
        this.simpleMessage = simpleMessage == null ? Activator.getDefault().getResource("ErrorCancelPanel.NoInfo") : simpleMessage;
        this.advancedMessage = advancedMessage == null ? Activator.getDefault().getResource("ErrorCancelPanel.NoAdvancedInfo") : advancedMessage;
        this.isSimple = false;
        this.optionName = optionName;
    }

    public IMailSettingsProvider getMailSettingsProvider() {
        return this.reportingComposite.getMailSettingsProvider();
    }

    public boolean doNotShowAgain() {
        return this.reportingComposite != null ? this.reportingComposite.isNotShowAgain() : false;
    }

    public void createControls(Composite parent) {
        GridData data = null;
        this.errorTextField = new Text(parent, 2818);
        data = new GridData(1808);
        data.heightHint = 100;
        this.errorTextField.setLayoutData((Object)data);
        this.errorTextField.setEditable(false);
        this.errorTextField.setText(this.simpleMessage);
        if (this.sendMail) {
            Composite mailComposite = new Composite(parent, 4);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            data = new GridData(1808);
            mailComposite.setLayout((Layout)layout);
            mailComposite.setLayoutData((Object)data);
            Label separator = new Label(mailComposite, 258);
            data = new GridData(768);
            separator.setLayoutData((Object)data);
            this.reportingComposite = new ReportingComposite(parent, this.dialogTitle, this.plugin, this.errorStatus, this.optionName, true, null);
            data = new GridData(1808);
            this.reportingComposite.setLayoutData(data);
        } else if (this.originalReport != null) {
            Button viewButton = new Button(parent, 8);
            viewButton.setText(Activator.getDefault().getResource("ErrorCancelPanel.OriginalReport"));
            data = new GridData();
            data.widthHint = DefaultDialog.computeButtonWidth(viewButton);
            viewButton.setLayoutData((Object)data);
            viewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreviewReportPanel panel = new PreviewReportPanel(Activator.getDefault().getResource("ErrorCancelPanel.OriginalReportPreview"), ErrorCancelPanel.this.originalReport);
                    DefaultDialog dialog = new DefaultDialog(UIMonitorUtil.getDisplay().getActiveShell(), panel);
                    dialog.open();
                }
            });
        }
    }

    public String getHelpId() {
        return "org.eclipse.team.svn.help.errorDialogContext";
    }

    protected void saveChanges() {
        if (this.sendMail) {
            this.reportingComposite.saveChanges();
        }
    }

    protected void cancelChanges() {
        if (this.sendMail) {
            this.reportingComposite.cancelChanges();
        }
    }

    protected void showDetails() {
    }

    public void postInit() {
        super.postInit();
        ((IDialogManagerEx)this.manager).setExtendedButtonEnabled(0, !this.simpleMessage.equalsIgnoreCase(this.advancedMessage));
    }

    public String getImagePath() {
        return "icons/dialogs/" + (this.panelType == 0 ? "operation_error.gif" : "select_revision.gif");
    }

    public void extendedButtonPressed(int idx) {
        if (this.isSimple) {
            ((IDialogManagerEx)this.manager).setExtendedButtonCaption(idx, Activator.getDefault().getResource("Button.Advanced"));
            this.errorTextField.setText(this.simpleMessage);
            this.isSimple = false;
        } else {
            ((IDialogManagerEx)this.manager).setExtendedButtonCaption(idx, Activator.getDefault().getResource("Button.Simple"));
            this.errorTextField.setText(this.advancedMessage);
            this.isSimple = true;
        }
    }

    public String getComment() {
        return this.reportingComposite.getComment();
    }

    public String getEmail() {
        return this.reportingComposite.getEmail();
    }

    public String getName() {
        return this.reportingComposite.getUserName();
    }

    public String getReportId() {
        return this.reportingComposite.getReportId();
    }

    public String getReport() {
        return this.reportingComposite.getReport();
    }
}

