/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.ui.composite.bamboo;

import com.atlassian.theplugin.eclipse.core.bamboo.IBambooServer;
import com.atlassian.theplugin.eclipse.preferences.Activator;
import com.atlassian.theplugin.eclipse.ui.composite.bamboo.BambooServerPropertiesComposite;
import com.atlassian.theplugin.eclipse.ui.dialog.DefaultDialog;
import com.atlassian.theplugin.eclipse.ui.panel.IPropertiesPanel;
import com.atlassian.theplugin.eclipse.ui.verifier.AbstractVerifier;
import com.atlassian.theplugin.eclipse.ui.verifier.IValidationManager;
import com.atlassian.theplugin.eclipse.view.bamboo.BambooConfigurationStorage;
import org.eclipse.compare.internal.TabFolderLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class BambooServerPropertiesTabFolder
extends Composite
implements IPropertiesPanel {
    protected Composite parent;
    protected IBambooServer bambooServer;
    protected int style;
    protected IValidationManager validationManager;
    protected Button validateButton;
    protected Button resetChangesButton;
    protected boolean validateOnFinish;
    protected boolean forceDisableRoots;
    protected boolean createNew;
    protected Combo cachedRealms;
    protected BambooServerPropertiesComposite serverPropertiesPanel;
    protected IBambooServer backup;

    public BambooServerPropertiesTabFolder(Composite parent, int style, IValidationManager validationManager, IBambooServer bambooServer) {
        super(parent, style);
        this.parent = parent;
        this.style = style;
        this.validationManager = validationManager;
        this.bambooServer = bambooServer;
        boolean bl = this.createNew = bambooServer == null;
        if (this.createNew) {
            this.bambooServer = BambooConfigurationStorage.instance().newBambooServer();
        } else {
            this.backup = BambooConfigurationStorage.instance().newBambooServer();
            BambooConfigurationStorage.instance().copyBambooServer(this.backup, this.bambooServer);
        }
    }

    public void initialize() {
        int widthHint;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 7;
        this.setLayout((Layout)layout);
        TabFolder tabFolder = new TabFolder((Composite)this, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout());
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Activator.getDefault().getResource("BambooServerPropertiesTabFolder.General"));
        tabItem.setControl(this.createBambooServerPropertiesPanel(tabFolder));
        GridData data = null;
        Composite bottomPart = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        bottomPart.setLayout((Layout)layout);
        data = new GridData(768);
        bottomPart.setLayoutData((Object)data);
        Composite realmsComposite = new Composite(bottomPart, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        realmsComposite.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 3;
        realmsComposite.setLayoutData((Object)data);
        Label label = new Label(realmsComposite, 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        label.setText(Activator.getDefault().getResource("BambooServerPropertiesTabFolder.ShowFor"));
        this.cachedRealms = new Combo(realmsComposite, 2056);
        this.validateButton = new Button(bottomPart, 32);
        data = new GridData(32);
        this.validateButton.setLayoutData((Object)data);
        this.validateButton.setText(Activator.getDefault().getResource("BambooServerPropertiesTabFolder.ValidateOnFinish"));
        this.validateButton.setSelection(true);
        Text empty = new Text(bottomPart, 8);
        data = new GridData(768);
        empty.setLayoutData((Object)data);
        empty.setVisible(false);
        this.resetChangesButton = new Button(bottomPart, 8);
        data = new GridData(128);
        this.resetChangesButton.setText(Activator.getDefault().getResource("BambooServerPropertiesTabFolder.ResetChanges"));
        data.widthHint = widthHint = DefaultDialog.computeButtonWidth(this.resetChangesButton);
        this.resetChangesButton.setLayoutData((Object)data);
        this.resetChangesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BambooServerPropertiesTabFolder.this.resetChanges();
                BambooServerPropertiesTabFolder.this.validationManager.validateContent();
            }
        });
    }

    protected Control createBambooServerPropertiesPanel(TabFolder tabFolder) {
        this.serverPropertiesPanel = new BambooServerPropertiesComposite((Composite)tabFolder, this.style, this.validationManager);
        this.serverPropertiesPanel.setBambooServer(this.bambooServer, this.createNew ? null : this.bambooServer.getUrl());
        this.serverPropertiesPanel.initialize();
        return this.serverPropertiesPanel;
    }

    protected void realmSelectionChanged() {
    }

    public IBambooServer getBambooServer() {
        return this.bambooServer;
    }

    public boolean isValidateOnFinishRequested() {
        return this.validateOnFinish;
    }

    public void saveChanges() {
        this.serverPropertiesPanel.saveChanges();
        this.validateOnFinish = this.validateButton.getSelection();
    }

    public void resetChanges() {
        this.serverPropertiesPanel.resetChanges();
    }

    public void cancelChanges() {
        if (!this.createNew) {
            BambooConfigurationStorage.instance().copyBambooServer(this.bambooServer, this.backup);
        }
    }

    public void setForceDisableRoots(boolean forceDisableRoots, AbstractVerifier verifier) {
    }

    public String getServerUrl() {
        return this.serverPropertiesPanel.getLocationUrl();
    }
}

