/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.ui.bamboo;

import com.atlassian.theplugin.eclipse.view.bamboo.IDataTreeNode;
import com.atlassian.theplugin.eclipse.view.bamboo.IParentTreeNode;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BambooTreeViewer
extends TreeViewer {
    public static final String FMT_REPOSITORY_RESOURCE = "";
    public static final String FMT_REPOSITORY_FILE = "";
    public static final String FMT_REPOSITORY_FOLDER = "";
    public static final String FMT_REPOSITORY_BRANCHES = "";
    public static final String FMT_REPOSITORY_ROOT = "";
    public static final String FMT_REPOSITORY_TAGS = "";
    public static final String FMT_REPOSITORY_TRUNK = "";
    protected List<IRefreshListener> refreshListeners = new ArrayList<IRefreshListener>();

    public BambooTreeViewer(Composite parent) {
        super(parent);
        this.initialize();
    }

    public BambooTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public BambooTreeViewer(Tree tree) {
        super(tree);
        this.initialize();
    }

    public synchronized void addRefreshListener(IRefreshListener listener) {
        if (!this.refreshListeners.contains(listener)) {
            this.refreshListeners.add(listener);
        }
    }

    public synchronized void removeRefreshListener(IRefreshListener listener) {
        this.refreshListeners.remove(listener);
    }

    public void setExpandedState(Object element, boolean expanded) {
        TreeItem[] items = this.getIdenticalNodes(element, true);
        if (items != null && items.length > 0) {
            if (expanded) {
                this.createChildren((Widget)items[0]);
            }
            this.setExpanded((Item)items[0], expanded);
        } else {
            TreeItem[] nodes = this.getIdenticalNodes(element, false);
            if (nodes != null && nodes.length > 0) {
                super.setExpandedState(nodes[0].getData(), expanded);
            }
        }
    }

    public void setSelection(ISelection selection) {
        IStructuredSelection tmp;
        TreeItem[] nodes;
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (nodes = this.getIdenticalNodes((tmp = (IStructuredSelection)selection).getFirstElement(), false)) != null && nodes.length > 0) {
            selection = new StructuredSelection(nodes[0].getData());
        }
        super.setSelection(selection);
    }

    public void refresh(final Object element, final IRefreshVisitor visitor, final boolean exact) {
        this.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                TreeItem[] nodes = BambooTreeViewer.this.getIdenticalNodes(element, exact);
                if (nodes != null && nodes.length != 0) {
                    for (int i = 0; i < nodes.length; ++i) {
                        Object data = nodes[i].getData();
                        if (visitor != null) {
                            visitor.visit(data);
                        }
                        BambooTreeViewer.this.internalRefresh((Widget)nodes[i], data, true, true);
                        BambooTreeViewer.this.fireRefresh(data);
                    }
                } else {
                    Object data;
                    Object input = BambooTreeViewer.this.getInput();
                    if (input instanceof IDataTreeNode && (data = ((IDataTreeNode)input).getData()) != null && data.equals(element) && visitor != null) {
                        visitor.visit(input);
                    }
                    BambooTreeViewer.super.refresh(null);
                }
            }
        });
    }

    public void fireEmptySelectionEvent() {
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)StructuredSelection.EMPTY));
    }

    protected void internalRefresh(Widget widget, Object element, boolean doStruct, boolean updateLabels) {
        if (widget instanceof Item) {
            if (doStruct) {
                this.updatePlus((Item)widget, element);
            }
            if (updateLabels || !this.equals(element, widget.getData())) {
                this.doUpdateItem(widget, element, true);
            } else {
                this.associate(element, (Item)widget);
            }
        }
        if (doStruct) {
            this.internalRefreshStruct(widget, element, updateLabels);
        } else {
            Item[] children = this.getChildren(widget);
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    Item item = children[i];
                    Object data = item.getData();
                    if (data == null) continue;
                    this.internalRefresh((Widget)item, data, doStruct, updateLabels);
                }
            }
        }
    }

    protected void internalRefreshStruct(Widget widget, Object element, boolean updateLabels) {
        try {
            Method m = AbstractTreeViewer.class.getDeclaredMethod("updateChildren", Widget.class, Object.class, Object[].class, Boolean.TYPE);
            m.setAccessible(true);
            m.invoke((Object)this, widget, element, null, updateLabels);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Item[] children = this.getChildren(widget);
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                Item item = children[i];
                Object data = item.getData();
                if (data == null) continue;
                this.internalRefreshStruct((Widget)item, data, updateLabels);
            }
        }
    }

    public void refresh() {
        this.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                BambooTreeViewer.super.refresh();
            }
        });
    }

    public TreeItem[] getIdenticalNodes(Object sample, boolean exact) {
        if (sample != null) {
            return this.findUnfreshNodes(this.getTree().getItems(), sample, exact);
        }
        return null;
    }

    protected synchronized void fireRefresh(Object data) {
        Object[] listeners = this.refreshListeners.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            ((IRefreshListener)listeners[i]).refreshed(data);
        }
    }

    protected TreeItem[] findUnfreshNodes(TreeItem[] items, Object obj, boolean exact) {
        List<TreeItem> retVal = this.findUnfreshNodesImpl(items, obj, exact);
        return retVal == null ? null : retVal.toArray(new TreeItem[retVal.size()]);
    }

    protected List<TreeItem> findUnfreshNodes(TreeItem item, Object obj, boolean exact) {
        IDataTreeNode dataNode;
        Object data = item.getData();
        if (obj == data || !exact && obj.equals(data)) {
            return Arrays.asList(item);
        }
        if (data instanceof IDataTreeNode && (obj == (dataNode = (IDataTreeNode)data).getData() || !exact && obj.equals(dataNode.getData()))) {
            return Arrays.asList(item);
        }
        return this.findUnfreshNodesImpl(item.getItems(), obj, exact);
    }

    protected List<TreeItem> findUnfreshNodesImpl(TreeItem[] items, Object obj, boolean exact) {
        if (items != null) {
            ArrayList<TreeItem> retVal = new ArrayList<TreeItem>();
            for (int i = 0; i < items.length; ++i) {
                List<TreeItem> tmp = this.findUnfreshNodes(items[i], obj, exact);
                if (tmp == null) continue;
                retVal.addAll(tmp);
            }
            return retVal;
        }
        return null;
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        TreeItem[] items;
        Object node = selection.getFirstElement();
        if (node instanceof IParentTreeNode && (items = this.getIdenticalNodes(node, true)) != null && items.length > 0) {
            boolean expanded;
            boolean bl = expanded = !this.getExpanded((Item)items[0]);
            if (expanded) {
                this.createChildren((Widget)items[0]);
            }
            this.setExpanded((Item)items[0], expanded);
        }
    }

    private void initialize() {
        this.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                IStructuredSelection structured;
                ISelection selection = e.getSelection();
                if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
                    BambooTreeViewer.this.handleDoubleClick(structured);
                }
            }
        });
    }

    public static interface IRefreshListener {
        public void refreshed(Object var1);
    }

    public static interface IRefreshVisitor {
        public void visit(Object var1);
    }
}

