/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.ui.bamboo;

import com.atlassian.theplugin.eclipse.preferences.Activator;
import com.atlassian.theplugin.eclipse.ui.action.bamboo.NewBambooServerAction;
import com.atlassian.theplugin.eclipse.ui.action.bamboo.RefreshBambooServerAction;
import com.atlassian.theplugin.eclipse.ui.bamboo.BambooContentProvider;
import com.atlassian.theplugin.eclipse.ui.bamboo.BambooServersRoot;
import com.atlassian.theplugin.eclipse.ui.bamboo.BambooTreeViewer;
import com.atlassian.theplugin.eclipse.ui.utility.UIMonitorUtil;
import com.atlassian.theplugin.eclipse.util.PluginIcons;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class BambooServersView
extends ViewPart {
    public static final String VIEW_ID = BambooServersView.class.getName();
    protected BambooTreeViewer bambooTree;
    protected DrillDownAdapter ddAdapter;
    protected Action showBrowserAction;
    protected IPartListener2 partListener;
    private BambooServersRoot root;

    public static MenuManager newMenuInstance(ISelectionProvider provider) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MenuManager sub = new MenuManager(Activator.getDefault().getResource("BambooServers.New"), "addMenu");
                sub.add((IContributionItem)new Separator("additions"));
                sub.add((IContributionItem)new Separator("mainGroup"));
                sub.add((IContributionItem)new Separator("managementGroup"));
                sub.add((IContributionItem)new Separator("repositoryGroup"));
                Action newRepositoryLocation = new Action(Activator.getDefault().getResource("BambooServers.BambooServer")){

                    public void run() {
                        new NewBambooServerAction().run((IAction)this);
                    }
                };
                newRepositoryLocation.setImageDescriptor(ImageDescriptor.createFromImage((Image)PluginIcons.getImageRegistry().get("Bamboo")));
                sub.add((IAction)newRepositoryLocation);
                manager.add((IContributionItem)sub);
                manager.add((IContributionItem)new Separator("additions"));
                manager.add((IContributionItem)new Separator("checkoutGroup"));
                sub = new MenuManager(Activator.getDefault().getResource("RepositoriesView.OpenWith"), "openWithMenu");
                sub.add((IContributionItem)new Separator("additions"));
                sub.add((IContributionItem)new Separator("dynamicGroup"));
                manager.add((IContributionItem)new Separator("miscGroup"));
                manager.add((IContributionItem)new Separator("locationGroup"));
                manager.add((IContributionItem)new Separator("propertiesGroup"));
                manager.add((IContributionItem)new Separator("refreshGroup"));
                manager.add((IContributionItem)new Separator("importExportGroup"));
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        return menuMgr;
    }

    public void createPartControl(Composite parent) {
        this.bambooTree = new BambooTreeViewer(parent, 770);
        this.bambooTree.setContentProvider((IContentProvider)new BambooContentProvider(this.bambooTree));
        this.bambooTree.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.bambooTree);
        this.root = new BambooServersRoot();
        this.bambooTree.setInput(this.root);
        this.ddAdapter = new DrillDownAdapter((TreeViewer)this.bambooTree);
        Tree tree = this.bambooTree.getTree();
        MenuManager menuMgr = BambooServersView.newMenuInstance((ISelectionProvider)this.bambooTree);
        tree.setMenu(menuMgr.createContextMenu((Control)tree));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.bambooTree);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager tbm = actionBars.getToolBarManager();
        this.ddAdapter.addNavigationActions(tbm);
        Action tAction = null;
        tAction = new Action(Activator.getDefault().getResource("BambooServers.Refresh.Label")){

            public void run() {
                if (BambooServersView.this.bambooTree.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)BambooServersView.this.bambooTree.getSelection();
                    BambooServersView.this.handleRefresh(selection);
                }
            }
        };
        tbm.add((IAction)tAction);
        tAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)PluginIcons.getImageRegistry().get("Refresh_bamboo_builds")));
        tAction.setToolTipText(Activator.getDefault().getResource("BambooServers.Refresh.ToolTip"));
        tbm.add((IContributionItem)new Separator("collapseAllGroup"));
        tAction = new Action(Activator.getDefault().getResource("BambooServers.CollapseAll.Label")){

            public void run() {
                BambooServersView.this.bambooTree.collapseAll();
            }
        };
        tbm.add((IAction)tAction);
        tAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)PluginIcons.getImageRegistry().get("Collapse_all")));
        tAction.setToolTipText(Activator.getDefault().getResource("BambooServers.CollapseAll.ToolTip"));
        tbm.add((IContributionItem)new Separator("repositoryGroup"));
        tAction = new Action(Activator.getDefault().getResource("BambooServers.NewServer.Label")){

            public void run() {
                new NewBambooServerAction().run((IAction)this);
            }
        };
        tbm.add((IAction)tAction);
        tAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)PluginIcons.getImageRegistry().get("Bamboo_new")));
        tAction.setToolTipText(Activator.getDefault().getResource("BambooServers.NewServer.ToolTip"));
        this.bambooTree.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (BambooServersView.this.bambooTree.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)BambooServersView.this.bambooTree.getSelection();
                    if (event.keyCode == 0x100000E) {
                        BambooServersView.this.handleRefresh(selection);
                    } else if (event.keyCode == 127) {
                        BambooServersView.this.handleDeleteKey(selection);
                    }
                }
            }
        });
        this.bambooTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                IStructuredSelection structured;
                ISelection selection = e.getSelection();
                if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
                    BambooServersView.this.handleDoubleClick(structured);
                }
            }
        });
        this.partListener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
                if (partRef.getId().equals(VIEW_ID)) {
                    BambooServersView.this.refreshRepositoriesImpl(false);
                }
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                if (partRef.getId().equals(VIEW_ID)) {
                    BambooServersView.this.getViewSite().getPage().removePartListener((IPartListener2)this);
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }
        };
        this.getViewSite().getPage().addPartListener(this.partListener);
    }

    public void dispose() {
        super.dispose();
        this.getViewSite().getPage().removePartListener(this.partListener);
    }

    public void setFocus() {
        this.bambooTree.getControl().setFocus();
    }

    public static void refresh(Object where) {
        BambooServersView.refresh(where, null);
    }

    public static void refresh(Object where, BambooTreeViewer.IRefreshVisitor visitor) {
        BambooServersView instance = BambooServersView.instance();
        if (instance != null) {
            instance.bambooTree.refresh(where, visitor, false);
        }
    }

    public static void refreshRepositories(boolean deep) {
        BambooServersView instance = BambooServersView.instance();
        if (instance != null) {
            instance.refreshRepositoriesImpl(deep);
        }
    }

    public void refreshButtonsState() {
        this.showBrowserAction.setChecked(false);
    }

    public static BambooServersView instance() {
        final BambooServersView[] view = new BambooServersView[1];
        UIMonitorUtil.getDisplay().syncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
                if (window != null && window.getActivePage() != null) {
                    view[0] = (BambooServersView)window.getActivePage().findView(VIEW_ID);
                }
            }
        });
        return view[0];
    }

    protected void refreshRepositoriesImpl(boolean deep) {
        if (deep) {
            this.root.refresh();
        } else {
            this.root.softRefresh();
        }
        this.bambooTree.refresh();
    }

    protected void showRepositoryBrowser(boolean force) {
    }

    protected void hideRepositoryBrowser() {
        IWorkbenchPage page = this.getSite().getPage();
        IViewPart part = page.findView(VIEW_ID);
        if (part != null) {
            page.hideView(part);
        }
    }

    protected void handleRefresh(IStructuredSelection selection) {
        Action tmp = new Action(){};
        RefreshBambooServerAction action = null;
        action = new RefreshBambooServerAction();
        action.selectionChanged((IAction)tmp, (ISelection)selection);
        action.setActivePart((IAction)tmp, (IWorkbenchPart)this);
        if (tmp.isEnabled()) {
            action.run((IAction)tmp);
        }
    }

    protected void handleDeleteKey(IStructuredSelection selection) {
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
    }

    public boolean canGoBack() {
        return this.ddAdapter.canGoBack();
    }

    public void goBack() {
        this.ddAdapter.goBack();
    }
}

