/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.preferences;

import com.atlassian.theplugin.commons.Server;
import com.atlassian.theplugin.commons.SubscribedPlan;
import com.atlassian.theplugin.commons.bamboo.BambooPlan;
import com.atlassian.theplugin.commons.bamboo.BambooPlanData;
import com.atlassian.theplugin.commons.bamboo.BambooServerFacade;
import com.atlassian.theplugin.commons.bamboo.BambooServerFacadeImpl;
import com.atlassian.theplugin.commons.configuration.ServerBean;
import com.atlassian.theplugin.commons.configuration.SubscribedPlanBean;
import com.atlassian.theplugin.commons.exception.ServerPasswordNotProvidedException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.commons.util.Logger;
import com.atlassian.theplugin.eclipse.EclipseActionScheduler;
import com.atlassian.theplugin.eclipse.preferences.Activator;
import com.atlassian.theplugin.eclipse.preferences.PreferencePageServers;
import com.atlassian.theplugin.eclipse.util.PluginIcons;
import com.atlassian.theplugin.eclipse.util.PluginUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BambooPlanListFieldEditor
extends FieldEditor
implements Preferences.IPropertyChangeListener {
    private static final String WAITING_FOR_PLANS_MESSAGE = "Waiting for plans list...";
    private Table table;
    private Set<SubscribedPlan> subscribedPlans;
    private PreferencePageServers parentPreferencePage;
    private Button refreshButton;
    private Text messageArea;
    private boolean useFavourites = false;
    private Composite parent;

    protected BambooPlanListFieldEditor() {
    }

    public BambooPlanListFieldEditor(String name, String labelText, Composite parent, PreferencePageServers preferencePageServers) {
        this.init(name, labelText);
        this.createControl(parent);
        this.parent = parent;
        this.parentPreferencePage = preferencePageServers;
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.table.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected void doFillIntoGrid(final Composite parent, int numColumns) {
        Label empty1 = new Label(parent, 0);
        this.refreshButton = new Button(parent, 8);
        this.refreshButton.setText("Refresh");
        this.refreshButton.setToolTipText("Refresh list using form values instead of saved ones");
        this.refreshButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                super.mouseUp(e);
                ServerBean bambooServer = new ServerBean();
                bambooServer.setUrlString(BambooPlanListFieldEditor.this.parentPreferencePage.getBambooUrl());
                bambooServer.setUserName(BambooPlanListFieldEditor.this.parentPreferencePage.getUserName());
                bambooServer.transientSetPasswordString(BambooPlanListFieldEditor.this.parentPreferencePage.getPassword(), Boolean.valueOf(true));
                BambooPlanListFieldEditor.this.loadServerPlans(bambooServer);
                BambooPlanListFieldEditor.this.refreshButton.setEnabled(false);
                BambooPlanListFieldEditor.this.setEnabled(false, parent);
                BambooPlanListFieldEditor.this.messageArea.setText(BambooPlanListFieldEditor.WAITING_FOR_PLANS_MESSAGE);
            }
        });
        Label label = this.getLabelControl(parent);
        GridData gdLabel = new GridData();
        gdLabel.verticalAlignment = 1;
        label.setLayoutData((Object)gdLabel);
        this.table = this.getTableControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = this.convertVerticalDLUsToPixels((Control)this.table, 70);
        gd.verticalAlignment = 4;
        this.table.setLayoutData((Object)gd);
        Label empty2 = new Label(parent, 0);
        this.messageArea = new Text(parent, 2570);
        gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.heightHint = 35;
        this.messageArea.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        this.subscribedPlans = this.subscribedPlansString2Collection(this.getPreferenceStore().getString(this.getPreferenceName()));
        this.loadServerPlans();
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.getStringValue());
    }

    public int getNumberOfControls() {
        return 2;
    }

    private String getStringValue() {
        if (this.table != null) {
            StringBuffer ret = new StringBuffer();
            for (TableItem item : this.table.getItems()) {
                if (!item.getChecked()) continue;
                ret.append(item.getText(2));
                ret.append(" ");
            }
            return ret.toString();
        }
        return this.getPreferenceStore().getString(this.getPreferenceName());
    }

    protected Table getTableControl() {
        return this.table;
    }

    private Table getTableControl(Composite parent) {
        if (this.table == null) {
            int style = 101152;
            this.table = new Table(parent, style);
            for (int i = 0; i < Column.values().length; ++i) {
                Column column = Column.values()[i];
                TableColumn tableColumn = new TableColumn(this.table, 16384);
                tableColumn.setText(column.columnName());
                tableColumn.setWidth(column.columnWidth());
                tableColumn.setMoveable(false);
                tableColumn.setResizable(false);
            }
            this.table.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    BambooPlanListFieldEditor.this.table = null;
                }
            });
        } else {
            this.checkParent((Control)this.table, parent);
        }
        return this.table;
    }

    public void setFocus() {
        if (this.table != null) {
            this.table.setFocus();
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled && !this.useFavourites || !enabled) {
            super.setEnabled(enabled, this.parent);
            this.getTableControl(this.parent).setEnabled(enabled);
        }
    }

    private void setPlans(Collection<BambooPlan> allPlans) {
        if (this.table != null && !this.table.isDisposed()) {
            this.fillTable(allPlans);
        }
    }

    private void fillTable(Collection<BambooPlan> serverPlans) {
        TableItem item;
        this.table.clearAll();
        this.table.setItemCount(0);
        for (BambooPlan bambooPlan : serverPlans) {
            item = new TableItem(this.table, 0);
            if (this.subscribedPlans.contains(new SubscribedPlanBean(bambooPlan.getPlanKey()))) {
                item.setChecked(true);
            }
            if (bambooPlan.isFavourite()) {
                item.setImage(Column.FAVOURITE.ordinal(), PluginIcons.getImageRegistry().get("Favourite on"));
            } else {
                item.setImage(Column.FAVOURITE.ordinal(), PluginIcons.getImageRegistry().get("Favourite off"));
            }
            item.setText(Column.PLAN_KEY.ordinal(), bambooPlan.getPlanKey());
        }
        for (SubscribedPlan subscribedPlan : this.subscribedPlans) {
            if (serverPlans.contains(new BambooPlanData(subscribedPlan.getPlanId()))) continue;
            item = new TableItem(this.table, 0);
            item.setChecked(true);
            item.setImage(Column.FAVOURITE.ordinal(), PluginIcons.getImageRegistry().get(PluginIcons.ICON_BAMBOO_UNKNOWN));
            item.setText(Column.PLAN_KEY.ordinal(), subscribedPlan.getPlanId());
        }
        this.setEnabled(true);
        this.refreshButton.setEnabled(true);
    }

    private Set<SubscribedPlan> subscribedPlansString2Collection(String subscribedPlans) {
        String[] plansArray;
        HashSet<SubscribedPlan> plansList = new HashSet<SubscribedPlan>();
        for (String plan : plansArray = subscribedPlans.split(" ")) {
            if (plan == null || plan.length() <= 0) continue;
            SubscribedPlanBean subscribedPlan = new SubscribedPlanBean(plan);
            plansList.add((SubscribedPlan)subscribedPlan);
        }
        return plansList;
    }

    private void loadServerPlans() {
        Collection servers = Activator.getDefault().getPluginConfiguration().getBambooConfigurationData().getServersData();
        Iterator iterator = servers.iterator();
        if (iterator.hasNext()) {
            ServerBean serverBean = (ServerBean)iterator.next();
            this.loadServerPlans(serverBean);
        }
    }

    private void loadServerPlans(final ServerBean bambooServer) {
        this.setEnabled(false);
        this.refreshButton.setEnabled(false);
        this.messageArea.setText(WAITING_FOR_PLANS_MESSAGE);
        Job planListJob = new Job("Atlassian Bamboo plans"){

            protected IStatus run(IProgressMonitor monitor) {
                Collection serverPlans = new ArrayList(0);
                BambooServerFacade bambooFacade = BambooServerFacadeImpl.getInstance((Logger)PluginUtil.getLogger());
                String message = "";
                try {
                    serverPlans = bambooFacade.getPlanList((Server)bambooServer);
                }
                catch (ServerPasswordNotProvidedException ex) {
                    message = ex.getMessage();
                }
                catch (RemoteApiException ex) {
                    message = ex.getMessage();
                }
                final Collection plans = serverPlans;
                final String finalMessage = message;
                EclipseActionScheduler.getInstance().invokeLater(new Runnable(){

                    public void run() {
                        if (BambooPlanListFieldEditor.this.messageArea != null && !BambooPlanListFieldEditor.this.messageArea.isDisposed()) {
                            BambooPlanListFieldEditor.this.messageArea.setText(finalMessage);
                        }
                        BambooPlanListFieldEditor.this.setPlans(plans);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        planListJob.schedule();
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (event.getProperty().equals("BAMBOO_URL") || event.getProperty().equals("BAMBOO_USER_NAME") || event.getProperty().equals("BAMBOO_USER_PASSWORD")) {
            this.doLoad();
        }
    }

    public void setFavourites(boolean useFavourites) {
        this.useFavourites = useFavourites;
        this.setEnabled(!useFavourites);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Column {
        WATCHED("Watched", 25),
        FAVOURITE("Favourite", 20),
        PLAN_KEY("Plan Key", 150);

        private String columnName;
        private int columnWidth;

        private Column(String columnName, int columnWidth) {
            this.columnName = columnName;
            this.columnWidth = columnWidth;
        }

        public static Column valueOfAlias(String text) {
            for (Column column : Column.values()) {
                if (!column.columnName().equals(text)) continue;
                return column;
            }
            return null;
        }

        public String columnName() {
            return this.columnName;
        }

        public int columnWidth() {
            return this.columnWidth;
        }

        public static String[] getNames() {
            ArrayList<String> list = new ArrayList<String>(Column.values().length);
            for (Column column : Column.values()) {
                list.add(column.name());
            }
            return list.toArray(new String[0]);
        }
    }
}

