/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.preferences;

import com.atlassian.theplugin.commons.configuration.BambooConfigurationBean;
import com.atlassian.theplugin.commons.configuration.BambooTooltipOption;
import com.atlassian.theplugin.commons.configuration.ServerBean;
import com.atlassian.theplugin.commons.configuration.SubscribedPlanBean;
import com.atlassian.theplugin.eclipse.preferences.BambooTabConfiguration;
import com.atlassian.theplugin.eclipse.preferences.EclipsePluginConfiguration;
import java.util.ArrayList;
import org.eclipse.core.runtime.Preferences;

public class ProjectConfigurationWrapper {
    private Preferences preferences;

    public ProjectConfigurationWrapper(Preferences preferences) {
        this.preferences = preferences;
    }

    public EclipsePluginConfiguration getPluginConfiguration() {
        String[] plans;
        ArrayList<SubscribedPlanBean> subscribedPlans = new ArrayList<SubscribedPlanBean>();
        for (String plan : plans = this.preferences.getString("BAMBOO_BUILDS").split(" ")) {
            if (plan == null || plan.length() <= 0) continue;
            SubscribedPlanBean subscribedPlan = new SubscribedPlanBean(plan);
            subscribedPlans.add(subscribedPlan);
        }
        ServerBean bambooServer = new ServerBean();
        bambooServer.setEnabled(Boolean.valueOf(true));
        bambooServer.setUserName(this.preferences.getString("BAMBOO_USER_NAME"));
        bambooServer.transientSetPasswordString(this.preferences.getString("BAMBOO_USER_PASSWORD"), Boolean.valueOf(true));
        bambooServer.setUrlString(this.preferences.getString("BAMBOO_URL"));
        bambooServer.setSubscribedPlansData(subscribedPlans);
        bambooServer.setUseFavourite(new Boolean(this.preferences.getString("BAMBOO_USE_FAVOURITES")));
        bambooServer.setName(this.preferences.getString("BAMBOO_NAME"));
        ArrayList<ServerBean> bambooServers = new ArrayList<ServerBean>();
        bambooServers.add(bambooServer);
        BambooConfigurationBean bambooConfiguration = new BambooConfigurationBean();
        bambooConfiguration.setServers(bambooServers);
        try {
            bambooConfiguration.setBambooTooltipOption(BambooTooltipOption.valueOf((String)this.preferences.getString("BAMBOO_POPUP")));
        }
        catch (IllegalArgumentException e) {
            bambooConfiguration.setBambooTooltipOption(null);
        }
        catch (NullPointerException e) {
            bambooConfiguration.setBambooTooltipOption(null);
        }
        bambooConfiguration.setPollTime(this.preferences.getInt("BAMBOO_POLLING_TIME"));
        EclipsePluginConfiguration pluginConfiguration = new EclipsePluginConfiguration();
        pluginConfiguration.setBambooConfigurationData(bambooConfiguration);
        BambooTabConfiguration bambooTabConfiguration = new BambooTabConfiguration();
        bambooTabConfiguration.setColumnsOrderString(this.preferences.getString("BAMBOO_TAB_COLUMNS_ORDER"));
        bambooTabConfiguration.setColumnsWidthString(this.preferences.getString("BAMBOO_TAB_COLUMNS_WIDTH"));
        pluginConfiguration.setBambooTabConfiguration(bambooTabConfiguration);
        return pluginConfiguration;
    }
}

