/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.preferences;

import com.atlassian.theplugin.commons.ConfigurationListener;
import com.atlassian.theplugin.commons.SchedulableChecker;
import com.atlassian.theplugin.commons.UIActionScheduler;
import com.atlassian.theplugin.commons.bamboo.BambooStatusChecker;
import com.atlassian.theplugin.commons.configuration.ConfigurationFactory;
import com.atlassian.theplugin.commons.configuration.PluginConfiguration;
import com.atlassian.theplugin.commons.configuration.PluginConfigurationBean;
import com.atlassian.theplugin.commons.util.Logger;
import com.atlassian.theplugin.eclipse.EclipseActionScheduler;
import com.atlassian.theplugin.eclipse.EclipseLogger;
import com.atlassian.theplugin.eclipse.MissingPasswordHandler;
import com.atlassian.theplugin.eclipse.preferences.BackgroundTaskType;
import com.atlassian.theplugin.eclipse.preferences.EclipsePluginConfiguration;
import com.atlassian.theplugin.eclipse.preferences.ProjectConfigurationWrapper;
import com.atlassian.theplugin.eclipse.util.PluginUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.atlassian.theplugin.eclipse";
    private static Activator plugin;
    private EclipsePluginConfiguration pluginConfiguration;
    private BambooStatusChecker bambooChecker;
    private Collection<Job> scheduledComponents = new ArrayList<Job>();
    private Collection<SchedulableChecker> schedulableCheckers = new ArrayList<SchedulableChecker>();
    private Set<ConfigurationListener> configurationListeners = new HashSet<ConfigurationListener>();
    private ConfigListener configListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        PluginUtil.setLogger((Logger)new EclipseLogger(this.getLog()));
        PluginUtil.getLogger().info(PluginUtil.getPluginName() + " started.");
        this.reloadConfiguration();
        MissingPasswordHandler missingPasswordHandler = new MissingPasswordHandler();
        this.bambooChecker = BambooStatusChecker.getInstance((UIActionScheduler)EclipseActionScheduler.getInstance(), (PluginConfiguration)this.pluginConfiguration, (Runnable)missingPasswordHandler, (Logger)PluginUtil.getLogger());
        this.schedulableCheckers.add((SchedulableChecker)this.bambooChecker);
        this.registerConfigurationListener((ConfigurationListener)this.bambooChecker);
        this.configListener = new ConfigListener();
        this.getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this.configListener);
        this.startTimer();
    }

    public void stop(BundleContext context) throws Exception {
        this.getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this.configListener);
        this.getPluginPreferences().setValue("BAMBOO_TAB_COLUMNS_ORDER", this.getPluginConfiguration().getBambooTabConfiguration().getColumnsOrderString());
        this.getPluginPreferences().setValue("BAMBOO_TAB_COLUMNS_WIDTH", this.getPluginConfiguration().getBambooTabConfiguration().getColumnsWidthString());
        this.disableTimer();
        plugin = null;
        super.stop(context);
    }

    public void registerConfigurationListener(ConfigurationListener configListener) {
        this.configurationListeners.add(configListener);
    }

    public void unregisterConfigurationListener(ConfigurationListener configListener) {
        this.configurationListeners.remove(configListener);
    }

    private void notifyConfigurationListeners() {
        for (ConfigurationListener listener : this.configurationListeners) {
            listener.updateConfiguration((PluginConfigurationBean)this.pluginConfiguration);
        }
    }

    public void reloadConfiguration() {
        ProjectConfigurationWrapper configurationWrapper = new ProjectConfigurationWrapper(this.getPluginPreferences());
        this.pluginConfiguration = configurationWrapper.getPluginConfiguration();
        ConfigurationFactory.setConfiguration((PluginConfiguration)this.pluginConfiguration);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public EclipsePluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public BambooStatusChecker getBambooChecker() {
        return this.bambooChecker;
    }

    private void disableTimer() {
        Job.getJobManager().cancel((Object)BackgroundTaskType.CHECKERS);
    }

    private void startTimer() {
        for (final SchedulableChecker checker : this.schedulableCheckers) {
            if (checker.canSchedule()) {
                final TimerTask newTask = checker.newTimerTask();
                Job newJob = new Job(checker.getName()){

                    protected IStatus run(IProgressMonitor monitor) {
                        newTask.run();
                        this.schedule(checker.getInterval());
                        return Status.OK_STATUS;
                    }

                    public boolean belongsTo(Object family) {
                        if (!(family instanceof BackgroundTaskType)) {
                            return false;
                        }
                        switch ((BackgroundTaskType)((Object)family)) {
                            case ALL: {
                                return true;
                            }
                            case CHECKERS: {
                                return true;
                            }
                        }
                        return false;
                    }
                };
                newJob.schedule(0L);
                this.scheduledComponents.add(newJob);
                continue;
            }
            checker.resetListenersState();
        }
    }

    public void rescheduleStatusCheckers() {
        this.disableTimer();
        this.startTimer();
    }

    public Device getDisplay() {
        return this.getWorkbench().getDisplay();
    }

    public Shell getShell() {
        return this.getWorkbench().getDisplay().getActiveShell();
    }

    public class ConfigListener
    implements Preferences.IPropertyChangeListener {
        public void propertyChange(Preferences.PropertyChangeEvent event) {
            Activator.this.reloadConfiguration();
            Activator.this.notifyConfigurationListeners();
            Activator.this.rescheduleStatusCheckers();
        }
    }
}

