/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.actions.bamboo;

import com.atlassian.theplugin.commons.exception.ServerPasswordNotProvidedException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.eclipse.actions.bamboo.BambooAction;
import com.atlassian.theplugin.eclipse.dialogs.bamboo.LabelBuildDialog;
import com.atlassian.theplugin.eclipse.preferences.Activator;
import com.atlassian.theplugin.eclipse.util.PluginUtil;
import com.atlassian.theplugin.eclipse.view.bamboo.BambooBuildAdapterEclipse;
import com.atlassian.theplugin.eclipse.view.bamboo.BambooToolWindow;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class LabelBuildAction
extends BambooAction {
    private static final String LABEL_BUILD = "Label Build";

    public LabelBuildAction(BambooToolWindow bambooToolWindow) {
        super(bambooToolWindow);
        this.setEnabled(false);
    }

    public void run() {
        super.run();
        final BambooBuildAdapterEclipse build = this.getBuild();
        LabelBuildDialog dialog = new LabelBuildDialog(Activator.getDefault().getShell(), build);
        dialog.open();
        if (dialog.getReturnCode() == 32 && dialog.getLabel().length() > 0) {
            final String label = dialog.getLabel();
            final String buildDesc = build.getBuildKey() + " " + build.getBuildNumber();
            Job labelBuild = new Job("Labeling build " + buildDesc){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        LabelBuildAction.this.setUIMessage("Labeling build " + buildDesc);
                        LabelBuildAction.this.bambooFacade.addLabelToBuild(build.getServer(), build.getBuildKey(), build.getBuildNumber(), label);
                        LabelBuildAction.this.setUIMessage("Build " + buildDesc + " labeled");
                    }
                    catch (ServerPasswordNotProvidedException e) {
                        LabelBuildAction.this.setUIMessage("Build " + buildDesc + "  not labeled. Password not provided for server");
                    }
                    catch (RemoteApiException e) {
                        LabelBuildAction.this.setUIMessage("Build  " + buildDesc + " not labeled. " + e.getMessage());
                    }
                    return Status.OK_STATUS;
                }
            };
            labelBuild.setPriority(20);
            labelBuild.schedule();
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.createFromImage((Image)PluginUtil.getImageRegistry().get("Label_bamboo_build"));
    }

    public String getText() {
        return LABEL_BUILD;
    }

    public String getToolTipText() {
        return LABEL_BUILD;
    }
}

