/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.actions.bamboo;

import com.atlassian.theplugin.commons.exception.ServerPasswordNotProvidedException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.eclipse.actions.bamboo.BambooAction;
import com.atlassian.theplugin.eclipse.dialogs.bamboo.CommentBuildDialog;
import com.atlassian.theplugin.eclipse.preferences.Activator;
import com.atlassian.theplugin.eclipse.util.PluginUtil;
import com.atlassian.theplugin.eclipse.view.bamboo.BambooBuildAdapterEclipse;
import com.atlassian.theplugin.eclipse.view.bamboo.BambooToolWindow;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class CommentBuildAction
extends BambooAction {
    private static final String COMMENT_BUILD = "Comment Build";

    public CommentBuildAction(BambooToolWindow bambooToolWindow) {
        super(bambooToolWindow);
        this.setEnabled(false);
    }

    public void run() {
        super.run();
        final BambooBuildAdapterEclipse build = this.getBuild();
        CommentBuildDialog dialog = new CommentBuildDialog(Activator.getDefault().getShell(), build);
        dialog.open();
        if (dialog.getReturnCode() == 32 && dialog.getComment().length() > 0) {
            final String comment = dialog.getComment();
            final String buildDesc = build.getBuildKey() + " " + build.getBuildNumber();
            Job labelBuild = new Job("Commenting build " + buildDesc){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        CommentBuildAction.this.setUIMessage("Commenting build " + buildDesc);
                        CommentBuildAction.this.bambooFacade.addCommentToBuild(build.getServer(), build.getBuildKey(), build.getBuildNumber(), comment);
                        CommentBuildAction.this.setUIMessage("Build " + buildDesc + " commented");
                    }
                    catch (ServerPasswordNotProvidedException e) {
                        CommentBuildAction.this.setUIMessage("Build " + buildDesc + "  not commented. Password not provided for server");
                    }
                    catch (RemoteApiException e) {
                        CommentBuildAction.this.setUIMessage("Build  " + buildDesc + " not commented. " + e.getMessage());
                    }
                    return Status.OK_STATUS;
                }
            };
            labelBuild.setPriority(20);
            labelBuild.schedule();
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.createFromImage((Image)PluginUtil.getImageRegistry().get("Comment_bamboo_build"));
    }

    public String getText() {
        return COMMENT_BUILD;
    }

    public String getToolTipText() {
        return COMMENT_BUILD;
    }
}

