/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.view.popup;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class TaskListImageDescriptor
extends CompositeImageDescriptor {
    private ImageData base;
    private ImageData overlay;
    private boolean top;
    private boolean left;
    protected Point size;

    public TaskListImageDescriptor(ImageDescriptor baseDesc, ImageDescriptor overlayDesc, boolean top, boolean left) {
        this.base = this.getImageData(baseDesc);
        this.top = top;
        this.left = left;
        if (overlayDesc != null) {
            this.overlay = this.getImageData(overlayDesc);
        }
        Point size = new Point(this.base.width, this.base.height);
        this.setImageSize(size);
    }

    public TaskListImageDescriptor(ImageDescriptor baseDesc, Point size) {
        this.base = this.getImageData(baseDesc);
        this.setImageSize(size);
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.base, 0, 0);
        int x = 0;
        int y = 0;
        if (!this.left) {
            x = 8;
        }
        if (!this.top) {
            y = 8;
        }
        if (this.overlay != null) {
            this.drawImage(this.overlay, x, y);
        }
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
        }
        return data;
    }

    public void setImageSize(Point size) {
        this.size = size;
    }

    protected Point getSize() {
        return new Point(this.size.x, this.size.y);
    }
}

