/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.preferences;

import com.atlassian.theplugin.eclipse.preferences.MyStringFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class MyIntegerFieldEditor
extends MyStringFieldEditor {
    private int minValidValue = 0;
    private int maxValidValue = Integer.MAX_VALUE;
    private static final int DEFAULT_TEXT_LIMIT = 10;

    protected MyIntegerFieldEditor() {
    }

    public MyIntegerFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, parent, 10);
    }

    public MyIntegerFieldEditor(String name, String labelText, Composite parent, int textLimit) {
        this.init(name, labelText);
        this.setTextLimit(textLimit);
        this.setWidthInChars(textLimit);
        this.setEmptyStringAllowed(false);
        this.setErrorMessage(JFaceResources.getString((String)"IntegerFieldEditor.errorMessage"));
        this.createControl(parent);
    }

    public void setValidRange(int min, int max) {
        this.minValidValue = min;
        this.maxValidValue = max;
        this.setErrorMessage(JFaceResources.format((String)"IntegerFieldEditor.errorMessageRange", (Object[])new Object[]{new Integer(min), new Integer(max)}));
    }

    protected boolean checkState() {
        Text text = this.getTextControl();
        if (text == null) {
            return false;
        }
        String numberString = text.getText();
        try {
            int number = Integer.valueOf(numberString);
            if (number >= this.minValidValue && number <= this.maxValidValue) {
                this.clearErrorMessage();
                return true;
            }
            this.showErrorMessage();
            return false;
        }
        catch (NumberFormatException e1) {
            this.showErrorMessage();
            return false;
        }
    }

    protected void doLoad() {
        Text text = this.getTextControl();
        if (text != null) {
            int value = this.getPreferenceStore().getInt(this.getPreferenceName());
            text.setText("" + value);
        }
    }

    protected void doLoadDefault() {
        Text text = this.getTextControl();
        if (text != null) {
            int value = this.getPreferenceStore().getDefaultInt(this.getPreferenceName());
            text.setText("" + value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        Text text = this.getTextControl();
        if (text != null) {
            Integer i = new Integer(text.getText());
            this.getPreferenceStore().setValue(this.getPreferenceName(), i.intValue());
        }
    }

    public int getIntValue() throws NumberFormatException {
        return new Integer(this.getStringValue());
    }
}

