/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.dialogs.bamboo;

import com.atlassian.theplugin.eclipse.view.bamboo.BambooBuildAdapterEclipse;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LabelBuildDialog {
    private Shell shell = null;
    private int returnCode = 0;
    private String returnText = null;
    private String buildPlan = null;
    private Text text = null;
    private Composite compositeRowButtons;

    public LabelBuildDialog(Shell parent, BambooBuildAdapterEclipse build) {
        this.shell = new Shell(parent, 67648);
        this.shell.setText("Label Build");
        this.shell.setLocation(parent.getLocation().x + parent.getSize().x / 2, parent.getLocation().y + parent.getSize().y / 2);
        this.buildPlan = build.getBuildKey() + " " + build.getBuildNumber();
        this.initialize();
    }

    private void initialize() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.shell.setLayout((Layout)gridLayout);
        this.shell.setSize(260, 140);
        this.createRowUpper();
        this.createRowBottom();
        this.createButtons();
    }

    private void createButtons() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.compositeRowButtons = new Composite((Composite)this.shell, 0);
        this.compositeRowButtons.setLayout((Layout)gridLayout);
        Button buttonOk = new Button(this.compositeRowButtons, 0);
        buttonOk.setText("Add Label");
        buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabelBuildDialog.this.returnCode = 32;
                LabelBuildDialog.this.returnText = LabelBuildDialog.this.text.getText();
                LabelBuildDialog.this.shell.close();
            }
        });
        this.shell.setDefaultButton(buttonOk);
        Button buttonCancel = new Button(this.compositeRowButtons, 0);
        buttonCancel.setText("Cancel");
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                LabelBuildDialog.this.returnCode = 256;
                LabelBuildDialog.this.shell.close();
            }
        });
    }

    private void createRowUpper() {
        Composite compositeRowUpper = null;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        compositeRowUpper = new Composite((Composite)this.shell, 0);
        compositeRowUpper.setLayout((Layout)gridLayout);
        Label text = new Label(compositeRowUpper, 0);
        text.setText("Add label to build " + this.buildPlan);
    }

    private void createRowBottom() {
        Composite compositeRowBottom = null;
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.widthHint = 220;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        compositeRowBottom = new Composite((Composite)this.shell, 0);
        compositeRowBottom.setLayout((Layout)gridLayout);
        this.text = new Text(compositeRowBottom, 2048);
        this.text.setLayoutData((Object)gridData);
    }

    public void open() {
        this.shell.open();
        Display display = this.shell.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String getLabel() {
        return this.returnText;
    }
}

