/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.actions.bamboo;

import com.atlassian.theplugin.commons.exception.ServerPasswordNotProvidedException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.eclipse.actions.bamboo.BambooAction;
import com.atlassian.theplugin.eclipse.dialogs.bamboo.LabelBuildDialog;
import com.atlassian.theplugin.eclipse.preferences.Activator;
import com.atlassian.theplugin.eclipse.util.PluginUtil;
import com.atlassian.theplugin.eclipse.view.bamboo.BambooBuildAdapterEclipse;
import com.atlassian.theplugin.eclipse.view.bamboo.BambooToolWindow;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class LabelBuildAction
extends BambooAction {
    private static final String LABEL_BUILD = "Label Build";

    public LabelBuildAction(BambooToolWindow bambooToolWindow) {
        super(bambooToolWindow);
        this.setEnabled(false);
    }

    public void run() {
        super.run();
        LabelBuildDialog dialog = new LabelBuildDialog(Activator.getDefault().getShell());
        dialog.open();
        if (dialog.getReturnCode() == 32) {
            final String label = dialog.getLabel();
            final BambooBuildAdapterEclipse build = this.getBuild();
            Thread labelBuild = new Thread(new Runnable(){

                public void run() {
                    try {
                        LabelBuildAction.this.setUIMessage("Labeling build on plan " + build.getBuildKey());
                        LabelBuildAction.this.bambooFacade.addLabelToBuild(build.getServer(), build.getBuildKey(), build.getBuildNumber(), label);
                        LabelBuildAction.this.setUIMessage("Build labeled on plan " + build.getBuildKey());
                    }
                    catch (ServerPasswordNotProvidedException e) {
                        LabelBuildAction.this.setUIMessage("Build not labeled. Password not provided for server");
                    }
                    catch (RemoteApiException e) {
                        LabelBuildAction.this.setUIMessage("Build not labeled. " + e.getMessage());
                    }
                }
            }, "atlassian-eclipse-plugin: Label Build Action thread");
            labelBuild.start();
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.createFromImage((Image)PluginUtil.getImageRegistry().get("Label_bamboo_build"));
    }

    public String getText() {
        return LABEL_BUILD;
    }

    public String getToolTipText() {
        return LABEL_BUILD;
    }
}

