/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public class MyTableFieldEditor
extends FieldEditor {
    private boolean isValid;
    private String oldValue;
    private String errorMessage;
    private TableViewer table;

    protected MyTableFieldEditor() {
    }

    public MyTableFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.isValid = false;
        this.errorMessage = JFaceResources.getString((String)"StringFieldEditor.errorMessage");
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.table.getTable().getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected boolean checkState() {
        return true;
    }

    protected boolean doCheckState() {
        return true;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.table = this.getTableControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.table.getTable().setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.table != null) {
            String value;
            this.oldValue = value = this.getPreferenceStore().getString(this.getPreferenceName());
        }
    }

    protected void doLoadDefault() {
        if (this.table != null) {
            String string = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        }
        this.valueChanged();
    }

    protected void doStore() {
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getNumberOfControls() {
        return 2;
    }

    public String getStringValue() {
        return this.getPreferenceStore().getString(this.getPreferenceName());
    }

    protected Table getTableControl() {
        return this.table.getTable();
    }

    private TableViewer getTableControl(Composite parent) {
        if (this.table == null) {
            int style = 101124;
            this.table = new TableViewer(parent, style);
            this.table.getTable().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    MyTableFieldEditor.this.table = null;
                }
            });
        } else {
            this.checkParent((Control)this.table.getTable(), parent);
        }
        return this.table;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void refreshValidState() {
        this.isValid = this.checkState();
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public void setFocus() {
        if (this.table != null) {
            this.table.getTable().setFocus();
        }
    }

    public void setStringValue(String value) {
        if (this.table != null) {
            if (value == null) {
                value = "";
            }
            if (!this.oldValue.equals(value)) {
                this.valueChanged();
            }
        }
    }

    public void showErrorMessage() {
        this.showErrorMessage(this.errorMessage);
    }

    protected void valueChanged() {
        String newValue;
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid;
        this.refreshValidState();
        if (this.isValid != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this.isValid);
        }
        if (!(newValue = "").equals(this.oldValue)) {
            this.fireValueChanged("field_editor_value", this.oldValue, newValue);
            this.oldValue = newValue;
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getTableControl(parent).getTable().setEnabled(enabled);
    }
}

