/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.eclipse.actions.bamboo;

import com.atlassian.theplugin.commons.exception.ServerPasswordNotProvidedException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.eclipse.actions.bamboo.BambooAction;
import com.atlassian.theplugin.eclipse.util.PluginUtil;
import com.atlassian.theplugin.eclipse.view.bamboo.BambooBuildAdapterEclipse;
import com.atlassian.theplugin.eclipse.view.bamboo.BambooToolWindow;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class RunBuildAction
extends BambooAction {
    private static final String RUN_BUILD = "Run Build";

    public RunBuildAction(BambooToolWindow bambooToolWindowTable) {
        super(bambooToolWindowTable);
    }

    public void run() {
        super.run();
        final BambooBuildAdapterEclipse build = this.getBuild();
        Job runBuild = new Job("Starting build on plan " + build.getBuildKey()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    RunBuildAction.this.setUIMessage("Starting build on plan " + build.getBuildKey());
                    RunBuildAction.this.bambooFacade.executeBuild(build.getServer(), build.getBuildKey());
                    RunBuildAction.this.setUIMessage("Build started on plan " + build.getBuildKey());
                }
                catch (ServerPasswordNotProvidedException e) {
                    RunBuildAction.this.setUIMessage("Build not started. Password not provided for server");
                }
                catch (RemoteApiException e) {
                    RunBuildAction.this.setUIMessage("Build not started. " + e.getMessage());
                }
                return Status.OK_STATUS;
            }
        };
        runBuild.setPriority(20);
        runBuild.schedule();
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.createFromImage((Image)PluginUtil.getImageRegistry().get("Run_bamboo_build"));
    }

    public String getToolTipText() {
        return RUN_BUILD;
    }
}

